import { Injectable } from '@angular/core';
import { HttpInterceptor, HttpRequest, HttpHandler, HttpEvent, HttpErrorResponse } from '@angular/common/http';
import { throwError, Observable, EMPTY } from 'rxjs';
import { catchError, exhaustMap } from 'rxjs/operators';
import { MatDialog } from '@angular/material/dialog';
import { OtpAuthDialogComponent } from './components/otp-auth-dialog/OtpAuthDialogComponent';

@Injectable()
export class OtpAuthInterceptor implements HttpInterceptor {
  constructor(
    private dialog: MatDialog,
  ) {
  }

  intercept(
    request: HttpRequest<any>,
    next: HttpHandler
  ): Observable<HttpEvent<any>> {
    return next.handle(request)
      .pipe(
        catchError((error: HttpErrorResponse) => {
          if (error.error &&
            error.error.error === 'required' && (
                error.error.error_param === 'otp_auth_email' ||
                error.error.error_param === 'otp_auth_password'
            )
          ) {
            return this.dialog.open(OtpAuthDialogComponent, {width: '35rem'}).afterClosed()
            .pipe(
              exhaustMap(result => {
                if (!result) {
                  return EMPTY;
                }

                const duplicate = request.clone({
                    body: {
                        ...request.body,
                        otpAuthPassword: result.otpAuthPassword
                    }
                });
                return next.handle(duplicate);
              })
            );
          }
          else {
            return throwError(error);
          }
        })
      );
  }
}
