import * as moment from 'moment';
import { Filter } from './types/filter';

export function isEmpty(val: any, allowEmptyArrayOrObject?: boolean): boolean {
    if (val == null) {
        return true;
    }

    if (Array.isArray(val)) {
        if (val.length < 1 && !allowEmptyArrayOrObject) {
            return true;
        }
        return false;
    }

    // lets check for object
    if (val.constructor === Object) {
        if (Object.keys(val).length < 1 && !allowEmptyArrayOrObject) {
            return true;
        }
        return false;
    }

    if (String(val).trim() === '') {
        return true;
    }

    return false;
}

export function filterGetQueryString(filters: Filter[]): string {
    // update filters
    let filtersString = '';

    for (const filter of filters) {
        if (filter.value == null) {
            continue;
        }

        let value: any = null;

        if (filter.value instanceof Date) {
            value = moment(filter.value).format('YYYY-MM-DD');
        } else {
            value = filter.value;
        }

        if (filtersString !== '') {
            filtersString += ';';
        }

        filtersString += filter.name + '=' + value;
    }
    return filtersString;
}

export function filterClear(filters: Filter[]): string {
    // update filters
    const filtersString = '';

    for (const filter of filters) {
        filter.value = null;
    }

    return filtersString;
}
