import { ErrorTranslate } from './types/ErrorTranslate';

export const ERROR: {[key: string]: ErrorTranslate} = {
    NOT_ENOUGH_FUNDS: {
        key: 'not_enough_funds',
        title: 'LABEL.ACCOUNT_BALANCE',
        message: 'SWAL.NOT_ENOUGH_FUNDS'
    },
    EMAIL_NOT_CONFIRMED: {
        key: 'email_not_confirmed',
        title: 'LABEL.CONFIRM_EMAIL',
        message: 'SWAL.EMAIL_NOT_CONFIRMED'
    },
    INVALID_ADDRESS: {
        key: 'invalid',
        title: 'SWAL.ERROR',
        message: 'SWAL.INVALID_ADDRESS'
    },
    BLACKLISTED_ADDRESS: {
        key: 'blacklisted',
        title: 'SWAL.ERROR',
        message: 'SWAL.BLACKLISTED_ADDRESS'
    },
    INVALID_OLD_PASSWORD: {
        key: 'invalid',
        title: 'SWAL.ERROR',
        message: 'SWAL.INVALID_OLD_PASSWORD'
    },
    NEW_PASSWORD_UNCHANGED: {
        key: 'unchanged',
        title: 'SWAL.ERROR',
        message: 'SWAL.NEW_PASSWORD_UNCHANGED'
    },
    AUTH_CODE_INVALID: {
        key: 'invalid',
        title: 'SWAL.ERROR',
        message: 'SWAL.AUTH_CODE_INVALID'
    },
    REQUIRED_MIN_TIER: {
        key: 'required_min_tier',
        title: 'SWAL.ERROR',
        message: 'SWAL.REQUIRED_MIN_TIER'
    },
    TOO_SMALL: {
        key: 'too_small',
        title: 'LABEL.ACCOUNT_BALANCE',
        message: 'SWAL.AMOUNT_IS_TOO_SMALL'
    },
    EXCHANGE_FAILED: {
        key: 'try_again_later',
        title: 'SWAL.ERROR',
        message: 'SWAL.EXCHANGE_FAILED'
    },
    UNUSED_ADDRESS: {
        key: 'unused_address',
        title: 'SWAL.ERROR',
        message: 'SWAL.UNUSED_ADDRESS'
    },
    INVALID_IBAN_ACCOUNT: {
        key: 'invalid',
        keyParam: 'beneficiaryAccount',
        title: 'SWAL.ERROR',
        message: 'SWAL.INVALID_IBAN_ACCOUNT'
    },
    INVALID_BENEFICIARY: {
        key: 'invalid',
        keyParam: 'beneficiary',
        title: 'SWAL.ERROR',
        message: 'SWAL.INVALID_BENEFICIARY'
    },
    REGISTRATION_DISABLED: {
        key: 'registration_disabled',
        title: 'SWAL.REGISTRATION_DISABLED_TITLE',
        message: 'SWAL.REGISTRATION_DISABLED_TEXT'
    },
    CREATE_IBAN_INVALID_DATA: {
        key: 'invalid',
        keyParam: 'applicantData',
        title: 'SWAL.CREATE_IBAN_INVALID_DATA',
        message: 'SWAL.CREATE_IBAN_INVALID_DATA_TEXT'
    },
    TRY_AGAIN_LATER: {
        key: 'try_again_later',
        title: 'SWAL.ERROR',
        message: 'SWAL.EXCHANGE_NOT_ENOUGH_FUNDS'
    },
    AMOUNT_TOO_SMALL: {
        key: 'too_small',
        keyParam: 'amount',
        title: 'SWAL.ACCOUNT_BALANCE',
        message: 'SWAL.AMOUNT_TOO_SMALL'
    },
    AMOUNT_TOO_LARGE: {
        key: 'too_large',
        keyParam: 'amount',
        title: 'SWAL.ACCOUNT_BALANCE',
        message: 'SWAL.AMOUNT_TOO_LARGE'
    },
    BASIC_AUTH_WRONG_CREDINTALS_EMAIL: {
        key: 'invalid',
        keyParam: 'basic_auth_email',
        title: 'SWAL.BASIC_AUTH_WRONG_CREDINTALS_TITLE',
        message: 'SWAL.BASIC_AUTH_WRONG_CREDINTALS_TEXT'
    },
    BASIC_AUTH_WRONG_CREDINTALS_PWD: {
        key: 'invalid',
        keyParam: 'basic_auth_password',
        title: 'SWAL.BASIC_AUTH_WRONG_CREDINTALS_TITLE',
        message: 'SWAL.BASIC_AUTH_WRONG_CREDINTALS_TEXT'
    },
    INVALID_RECOVERY_CODE: {
        key: 'invalid',
        keyParam: 'recoveryCode',
        title: 'SWAL.INVALID_RECOVERY_CODE',
        message: 'SWAL.INVALID_RECOVERY_CODE'
    },
    MIN_COMMISSION_HIGHER: {
        key: 'min_commission_higher',
        title: 'SWAL.INVALID_AMOUNT_TITLE',
        message: 'SWAL.AMOUNT_TOO_SMALL'
    },
    RECIPIENT_NOT_FOUND: {
        key: 'recipient_not_found',
        title: 'SWAL.INVALID_RECIPIENT',
        message: 'SWAL.RECIPIENT_NOT_FOUND'
    },
    RECIPIENT_NO_ACCOUNT: {
        key: 'recipient_no_account',
        title: 'SWAL.INVALID_RECIPIENT',
        message: 'SWAL.RECIPIENT_NO_ACCOUNT'
    },
    RECIPIENT_SAME_USER: {
        key: 'recipient_same_user',
        title: 'SWAL.INVALID_RECIPIENT',
        message: 'SWAL.RECIPIENT_SAME_USER'
    }
};
