import { HttpErrorResponse, HttpEvent, HttpHandler, HttpInterceptor, HttpRequest } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { MatDialog } from '@angular/material/dialog';
import { EMPTY, Observable, throwError } from 'rxjs';
import { catchError, exhaustMap } from 'rxjs/operators';
import { BasicAuthDialogComponent } from './components/basic-auth-dialog/BasicAuthDialogComponent';

@Injectable()
export class BasicAuthInterceptor implements HttpInterceptor {
  constructor(
    private readonly dialog: MatDialog,
  ) {
  }

  intercept(
    request: HttpRequest<any>,
    next: HttpHandler
  ): Observable<HttpEvent<any>> {
    return next.handle(request)
      .pipe(
        catchError((error: HttpErrorResponse) => {
          if (error.error &&
            error.error.error === 'required' && (
                error.error.error_param === 'basic_auth_email' ||
                error.error.error_param === 'basic_auth_password'
            )
          ) {
            return this.dialog.open(BasicAuthDialogComponent, {width: '35rem'}).afterClosed()
            .pipe(
              exhaustMap(result => {
                if (!result) {
                  return EMPTY;
                }

                const duplicate = request.clone({
                    body: {
                        ...request.body,
                        basicAuthEmail: result.basicAuthEmail,
                        basicAuthPassword: result.basicAuthPassword
                    }
                });
                return next.handle(duplicate);
              })
            );
          }
          else {
            return throwError(error);
          }
        })
      );
  }
}
