import { Payment } from '@app/shared/types/Payment';
import { Wallet } from './../../../shared/types/Wallet';
import { Component, OnInit } from '@angular/core';
import { FormGroup, FormBuilder } from '@angular/forms';
import { ClipboardService } from 'ngx-clipboard';
import { Logger } from '@app/core/LoggerService';
import { transactionsDetails } from '../../transactions/TransactionsMockData';
import { MatDialog } from '@angular/material/dialog';
import { DialogComponent } from '@app/shared/components/dialog-component/DialogComponent';
import { Router, ActivatedRoute } from '@angular/router';
import { HttpClient } from '@angular/common/http';
import { MatTableDataSource } from '@angular/material/table';

@Component({
  selector: 'app-wallet-settings',
  templateUrl: './wallet-settings-component.html',
  styleUrls: ['./wallet-settings-component.scss'],
})
export class WalletSettingsComponent implements OnInit {
  private readonly logger = new Logger(WalletSettingsComponent.name);

  public pendingAmount = 1;
  public accountGroup: FormGroup;
  public mockDataSource = transactionsDetails;
  public transactions: MatTableDataSource<Payment>;
  public account: Wallet = null;

  public transactionStatementDisplayedColumns = [
    'activity',
    'asset',
    'accountName',
    'amount',
    'status',
    'createdDate',
    'details',
    'print',
  ];

  public pendingDisplayedColumns = [
    'activity',
    'asset',
    'accountName',
    'amount',
    'status',
    'action'
  ];

  constructor(
    private readonly formBuilder: FormBuilder,
    private readonly dialog: MatDialog,
    private readonly router: Router,
    private readonly httpClient: HttpClient,
    private readonly activatedRoute: ActivatedRoute,
    private readonly clipboardService: ClipboardService
  ) {
    this.accountGroup = this.formBuilder.group({
      keyRecovery: [],
      coSign: [],
    });
  }

  ngOnInit(): void {
    const walletId: number = Number(this.activatedRoute.snapshot.params.id);
    this.httpClient.get<Wallet>(`/wallet/${walletId}`).subscribe(data => {
      this.account = data;
      this.getWalletPayments(this.account.id);
    });
  }

  public getWalletPayments(walletId: number): void {
    this.httpClient.get<any[]>(`/payment/wallet-payments/${walletId}`).subscribe(data => {
      this.transactions = new MatTableDataSource(data);
    });
  }

  public copy(text: string): void {
    this.clipboardService.copyFromContent(text);
  }

  public receive(): void {
    this.dialog.open(DialogComponent, {
      data: {
        type: 'receiveAmount',
        header: 'Wallet Address',
        content: {
          currencyCode: this.account.currency.code,
          accountAddress: '0x0000000000000000000000000000000000000000',
        },
      },
      autoFocus: false
    });
  }

  public send(): void {
    this.router.navigateByUrl(`/wallets/create-transaction/${this.account.id}`);
  }
}
