import { Component } from '@angular/core';
import { Logger } from '@app/core/LoggerService';
import { CheckBoxWithStatus } from '@app/shared/components/checkbox-status-component/CheckboxStatusComponent';
import { FormGroup, FormBuilder, FormControl } from '@angular/forms';
import { ClipboardService } from 'ngx-clipboard';
import { SelectType } from '@app/shared/components/select-component/SelectComponent';

@Component({
  selector: 'app-create-account',
  templateUrl: './create-account-component.html',
  styleUrls: ['./create-account-component.scss'],
})
export class CreateAccountComponent {
  private readonly logger = new Logger(CreateAccountComponent.name);

  public mobileCode = 'lesssgetdisbreaaad';
  public desktopCode = 'e8b1581e-392f-40c2-9153-beb9a0f964d';
  public emailConfirmation = false;

  public selectedCosign: any[] = [
    {email: 'test@test.test'},
    {email: 'test@test.test'},
    {email: 'test@test.test'}
  ];

  public newAccountGroup: FormGroup;

  public checkboxLayout: CheckBoxWithStatus[] = [
    {
      name: 'Key Recovery',
      formControl: new FormControl(false),
      formControlName: 'keyRecovery',
      tooltip: 'Key Recovery',
      status: 'PENDING',
    },
    {
      name: 'xDaro Co-Signing',
      formControl: new FormControl(false),
      formControlName: 'coSign',
      tooltip: 'xDaro Co-Signing',
      status: 'PENDING',
    },
    {
      name: 'Smart Mobile Key',
      formControl: new FormControl(false),
      formControlName: 'mobileKey',
      tooltip: 'Smart Mobile Key',
      status: 'PENDING_WAITING',
    },
    {
      name: 'Desktop Verification',
      formControl: new FormControl(false),
      formControlName: 'desktopVerif',
      tooltip: 'Desktop Verification',
      status: 'APPROVED',
    },
    {
      name: 'Email Verification',
      formControl: new FormControl(false),
      formControlName: 'emailVerif',
      tooltip: 'Email Verification',
      status: 'PENDING',
    },
  ];

  public selectLayout: SelectType[] = [
    {
      header: 'Choose Account',
      tooltip: 'Choose Account',
      options: [
        { value: 'private', viewValue: 'Private (Code A:11)' },
        { value: 'business', viewValue: 'Business (Code A:21)' },
        { value: 'manager', viewValue: 'Business (Code A:31)' },
      ],
    },
    {
      header: 'Choose Asset Type',
      options: [
        { viewValue: 'All Asset Types', value: 'all' },
        { viewValue: 'Digital Fiat (Code T:1)', value: 'digital' },
        { viewValue: 'Security tokens (Code T:2)', value: 'security' },
        { viewValue: 'Crypto Currency (Code T:3)', value: 'crypto' },
        { viewValue: 'Property Backed Tokens (Code T:4)', value: 'property' },
        { viewValue: 'Digital Collectibles (Code T:5)', value: 'collectible' },
      ],
    },
    { header: 'Choose DLT Type', options: [{ viewValue: 'BTC', value: 'all' }] },
    {
      header: 'Select required signatures:',
      tooltip: 'DLT Type',
      options: [
        { viewValue: '2', value: '2' },
        { viewValue: '4', value: '4' },
        { viewValue: '6', value: '6' },
      ],
    },
  ];

  public cosigningList: SelectType[] = [
    {
      header: 'Select co-signing users:',
      tooltip: 'Select co-signing users',
      options: [
        { viewValue: 'John doe', value: 'unkwn1' },
        { viewValue: 'John smith', value: 'unkwn2' },
        { viewValue: 'Jane doe', value: 'unkwn3' },
      ],
    },
  ];

  constructor(
    private readonly formBuilder: FormBuilder,
    private readonly clipboardService: ClipboardService
  ) {
    this.newAccountGroup = this.formBuilder.group({
      keyRecovery: [],
      coSign: [],
      mobileKey: [],
      desktopVerif: [],
      emailVerif: [],
    });
  }

  public copy(text: string): void {
    this.clipboardService.copyFromContent(text);
  }

  public checkboxHandler(event: any, checkbox: string): void {
    const changedCheckbox = this.checkboxLayout.find((x) => x.formControlName === checkbox);
    this.newAccountGroup.get(checkbox).setValue(event);

    if (event === true) {
      changedCheckbox.status = 'PENDING_WAITING';
    } else if (event === false) {
      changedCheckbox.status = 'PENDING';
    }
  }

  public selectHandler(event: any, select: any): void {
  }

  public sendEmailConfirm(): void {
    this.emailConfirmation = true;
  }

  public addSigner(): void {
    const formData: SelectType = {
      header: 'Select co-signing users:',
      tooltip: 'Select co-signing users',
      options: [
        { viewValue: 'John doe', value: 'unkwn1' },
        { viewValue: 'John smith', value: 'unkwn2' },
        { viewValue: 'Jane doe', value: 'unkwn3' },
      ],
    };
    this.cosigningList.push(formData);
  }

  public removeSigner(user: any): void {
  }
}
