import { Component } from '@angular/core';
import { FormGroup, FormBuilder, FormControl } from '@angular/forms';
import { Logger } from '@app/core/LoggerService';
import { SelectType } from '@app/shared/components/select-component/SelectComponent';
import { CheckBoxWithStatus } from '@app/shared/components/checkbox-status-component/CheckboxStatusComponent';

@Component({
  selector: 'app-account-settings',
  templateUrl: './account-settings-component.html',
  styleUrls: ['./account-settings-component.scss'],
})
export class AccountSettingsComponent {
  private readonly logger = new Logger(AccountSettingsComponent.name);

  public accountGroup: FormGroup;
  public account = {
    currencyCode: 'BTC',
    accountName: 'Cold Storage',
    amount: 0.13,
    euro: 1002,
    accountId: 1,
    settingCode1: 'A:11',
    settingCode2: 'T:1',
    expandText: 'test',
    status: 'PENDING',
  };

  public accountType: SelectType = {
      options: [
        { value: 'private', viewValue: 'Private (Code A:11)' },
        { value: 'business', viewValue: 'Business (Code A:21)' },
        { value: 'manager', viewValue: 'Business (Code A:31)' },
      ],
    };

    public checkboxLayout: CheckBoxWithStatus[] = [
      {
        name: 'Key Recovery',
        formControl: new FormControl(true),
        formControlName: 'keyRecovery',
        status: 'APPROVED',
      },
      {
        name: 'xDaro Co-Signing',
        formControl: new FormControl(false),
        formControlName: 'coSign',
        status: 'PENDING',
      },
      {
        name: 'Smart Mobile Key',
        formControl: new FormControl(false),
        formControlName: 'mobileKey',
        tooltip: 'Smart Mobile Key',
        status: 'PENDING_WAITING',
      },
      {
        name: 'Desktop Verification',
        formControl: new FormControl(false),
        formControlName: 'desktopVerif',
        tooltip: 'Desktop Verification',
        status: 'APPROVED',
      },
      {
        name: 'Email Verification',
        formControl: new FormControl(false),
        formControlName: 'emailVerif',
        tooltip: 'Email Verification',
        status: 'PENDING',
      },
    ];

    public coSignPartie = [
      { name: 'test@test.test',
        formControl: new FormControl(true),
        formControlName: 'partie1',
        status: 'PENDING_WAITING',
      },
      { name: 'test@test.test',
        formControl: new FormControl(true),
        formControlName: 'partie2',
        status: 'PENDING_WAITING',
      },
      { name: 'test@test.test',
        formControl: new FormControl(true),
        formControlName: 'partie3',
        status: 'APPROVED',
      },
      { name: 'test@test.test',
        formControl: new FormControl(true),
        formControlName: 'partie4',
        status: 'PENDING_WAITING',
      },
    ];

  constructor(
    private readonly formBuilder: FormBuilder
  ) {
    this.accountGroup = this.formBuilder.group({
      keyRecovery: [],
      coSign: [],
    });
  }

  public accountTypeChange(e: any): void {
  }

  public checkboxHandler(event: any, checkbox: string): void {
    const changedCheckbox = this.checkboxLayout.find((x) => x.formControlName === checkbox);
    this.accountGroup.get(checkbox).setValue(event);

    if (event === true) {
      changedCheckbox.status = 'PENDING_WAITING';
    } else if (event === false) {
      changedCheckbox.status = 'PENDING';
    }
  }
}
