import { NgModule } from '@angular/core';
import { Routes, RouterModule } from '@angular/router';
import { WalletsComponent } from './WalletsComponent';
import { extract } from '@app/core/I18nService';
import { CreateAccountComponent } from './create-account/CreateAccountComponent';
import { WalletSettingsComponent } from './wallet-settings/WalletSettingsComponent';
import { CreateTransactionComponent } from './create-transaction/CreateTransactionComponent';

const routes: Routes = [
  {
    path: '',
    component: WalletsComponent,
    data: { title: extract('xDaro') },
  },
  { path: 'create', component: CreateAccountComponent},
  { path: 'wallet-settings/:id', component: WalletSettingsComponent},
  { path: 'create-transaction/:id', component: CreateTransactionComponent}
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
  providers: []
})
export class WalletsRoutingModule { }
