import { SwalService } from './../../shared/services/SwalService';
import { HttpClient, HttpErrorResponse } from '@angular/common/http';
import { Component, OnInit } from '@angular/core';
import { Logger } from '../../core/LoggerService';
import { FormBuilder, FormGroup } from '@angular/forms';
import { transactionsDetails } from './TransactionsMockData';
import { Payment } from '@app/shared/types/Payment';
import { MatTableDataSource } from '@angular/material/table';

// label: string;
// bold?: string;
// type?: string;
// placeholder?: string;
// suffix?: {
//   type: string;
//   icon?: string;
//   text?: string;
// };
// formControlName: string;

@Component({
    selector: 'app-transactions',
    templateUrl: './transactions-component.html',
    styleUrls: ['./transactions-component.scss'],
})
export class TransactionsComponent implements OnInit {
    private readonly logger = new Logger(TransactionsComponent.name);

    public pendingAmount = transactionsDetails.length;
    public transactionSearchGroup: FormGroup;
    public transactionDataSource = transactionsDetails;
    public allTransactions: MatTableDataSource<Payment>;

    // Just for visual info on a page
    public newAllTransactions = transactionsDetails;

    public transactionSearchFields = [
        { type: 'number', field: { label: 'Amount From', formControlName: 'amountFrom' } },
        { type: 'number', field: { label: 'Amount To', formControlName: 'amountFrom' } },
        { type: 'text', field: { label: 'Wallet From', formControlName: 'amountFrom' } },
        { type: 'text', field: { label: 'Address To', formControlName: 'amountFrom' } },
        { type: 'text', field: { label: 'Note', formControlName: 'amountFrom' } },
        {
            type: 'select',
            field: {
                header: 'Text',
                formControlName: 'text',
                options: [
                    { viewValue: 'text', value: 'text' },
                    { viewValue: 'Rambo', value: 'rambone' },
                ],
            },
        },
    ];

    public transactionStatementDisplayedColumns = [
        'activity',
        'asset',
        'accountName',
        'amount',
        'status',
        'createdDate',
        'details',
        'print',
    ];

    public pendingDisplayedColumns = [
        'activity',
        'asset',
        'accountName',
        'amount',
        'status',
        'action'
    ];

    constructor(
        private readonly formBuilder: FormBuilder,
        private readonly httpClient: HttpClient,
        private readonly swalService: SwalService
    ) {
        this.transactionSearchGroup = this.formBuilder.group({
            amountFrom: [],
            amountTo: [],
            walletFrom: [],
            addressTo: [],
            note: [],
            text: [],
            dateFrom: [],
            dateTo: []
        });
    }

    ngOnInit(): void {
        this.refresh();
    }
    public refresh(): void {
        this.httpClient.get<Payment[]>('/payment/list').subscribe(data => {
            this.allTransactions = new MatTableDataSource(data);
        }, (error: HttpErrorResponse) => {
            this.swalService.showError({ title: 'Error', text: error.message });
        });
    }
}
