import { Component } from '@angular/core';
import { Logger } from '../../core/LoggerService';
import { FormBuilder, Validators, FormGroup } from '@angular/forms';
import { FormFieldDesign } from '@app/shared/types/FormFieldDesign';

export interface FileError {
  type?: any;
  size?: any;
}

export interface TicketTableData {
  id: number;
  createdDate: Date;
  subject: string;
  status: string;
  messages: {text: string, date: Date, authorIsMe: boolean}[];
}

const ticketDataSource: TicketTableData[] = [
  {id: 1, createdDate: new Date(), subject: 'Lost key', status: 'Rejected', messages: [
    {text: 'Ive been flying', date: new Date(), authorIsMe: true },
    {text: 'Really nice texterino', date: new Date(), authorIsMe: false }
  ]},
  {id: 2, createdDate: new Date(), subject: 'Guud text', status: 'Rejected', messages: [
    {text: 'Nothing to be found', date: new Date(), authorIsMe: false},
    {text: 'Void', date: new Date(), authorIsMe: true}
  ]},
];

@Component({
  selector: 'app-support',
  templateUrl: './support-component.html',
  styleUrls: ['./support-component.scss'],
})
export class SupportComponent {
  private readonly logger = new Logger(SupportComponent.name);

  public dataSource: any = ticketDataSource;
  public formGroup: FormGroup;

  public design: FormFieldDesign = {
    header: 'no-bold',
    field: 'stroked'
  };

  public formFields = [
    { label: 'Subject', formControlName: 'subject' },
    { label: 'Message', formControlName: 'message', type: 'textarea' },
  ];

  public selectedImages = [];
  public wrongFiles: any[] = [];

  fileTypes = ['image/jpg', 'image/jpeg', 'image/png', 'application/pdf'];

  constructor(
    private readonly formBuilder: FormBuilder
  ) {
    this.formGroup = this.formBuilder.group({
      subject: [null, Validators.required],
      message: [null, Validators.required],
    });
  }

  public submitTicket(): void {
  }

  removeFile(file: any): void {
    this.selectedImages.splice(this.selectedImages.findIndex(x => x.name === file.name), 1);
  }

  public uploadImage(files: any): void {
    // TODO: what is '5'?
    if (files.length === 0 || files.length > 5) {
      return;
    }

    const incorrectFiles: FileError = {
      type: [],
      size: [],
    };

    // determine file (if valid)
    // tslint:disable-next-line: prefer-for-of
    for (let i = 0; i < files.length; i++) {
      // TODO: what is '5'?
      if (this.selectedImages.length === 5) {
        return;
      }

      const currentFileName = files[i].name;

      // TODO: what is '5000000'?
      if (files[i].size > 5_000_000 && this.selectedImages.length < 5) {
        incorrectFiles.size.push(currentFileName);
        continue;
      }

      // TODO: what is '5'?
      if (this.fileTypes.indexOf(files[i].type) === -1 && this.selectedImages.length < 5) {
        incorrectFiles.type.push(currentFileName);
        continue;
      }

      // TODO: what is '5'?
      if (this.fileTypes.indexOf(files[i].type) !== -1 && this.selectedImages.length < 5) {
        this.selectedImages.push(files[i]);
        continue;
      }
    }

    // throw error if not valid files exist
    if (incorrectFiles.type.length > 0 || incorrectFiles.size.length > 0) {
      let errorString = '';

      if (incorrectFiles.type.length > 0 && incorrectFiles.size.length > 0) {
        errorString += this.createString(incorrectFiles.type);
        errorString += this.createString(incorrectFiles.size);
        // this.swalService.showError({ title: 'SWAL.ERROR', html: 'SWAL.MULTIPLE_INCORRECT_FILES', htmlParams: { list: errorString}});
        return;
      }
      if (incorrectFiles.type.length > 0) {
        errorString = this.createString(incorrectFiles.type);
        // this.swalService.showError({ title: 'SWAL.ERROR', html: 'SWAL.INCORRECT_FILES', htmlParams: { list: errorString } })
        return;
      }
      if (incorrectFiles.size.length > 0) {
        errorString = this.createString(incorrectFiles.size);
        // this.swalService.showError({ title: 'SWAL.ERROR', html: 'SWAL.FILES_SIZE_TOO_LARGE', htmlParams: { list: errorString } })
        return;
      }
    }
  }

  // TODO: naming
  // TODO: rework
  public createString(array: any): string {
    let fullString = '';
    // tslint:disable-next-line: prefer-for-of
    for (let i = 0; i < array.length; i++) {
      const srt = array[i];
      if (srt != null && srt !== undefined && srt.length > 0) {
        fullString += srt + '<br>';
      }
    }
    return fullString;
  }
}
