import { Component, Input } from '@angular/core';
import { UserDetailsKVInterface, UserInfoKVInterface } from '../ProfileComponent';

@Component({
  selector: 'app-profile-section',
  templateUrl: './profile-section-component.html',
  styleUrls: ['./profile-section-component.scss'],
})
export class ProfileSectionComponent {
  public profileImage = 'assets/images/user-blank.jpg';

  @Input() userInfo: UserInfoKVInterface;
  @Input() userDetails: UserDetailsKVInterface;

  //
  // Upload user image
  //
  public uploadImage(ev: any): void {
    if (ev.target.files.length === 0) {
      return;
    }

    const formData = new FormData();
    formData.append('avatar', ev.target.files[0]);
  }
}
