import { Component, OnInit, Input } from '@angular/core';
import { FormGroup, FormBuilder } from '@angular/forms';
import { KycTierLimit } from '@app/shared/types/KycTierLimit';

@Component({
  selector: 'app-tier-platinum',
  templateUrl: './tier-platinum-component.html',
  styleUrls: ['./tier-platinum-component.scss'],
})
export class TierPlatinumComponent {
  public kycTierLimitColumns: string[] = ['title', 'day', 'month', 'annual'];

  public communicationTypes: { label: string; value: string }[] = [
    { label: 'Skype', value: 'skype' },
    { label: 'Zoom', value: 'zoom' },
    { label: 'Teamviewer', value: 'teamviewer' },
    { label: 'Phone', value: 'phone' },
  ];

  public formFields = [
    { label: 'Enter your skype name', formControlName: 'meetingType' },
    { label: 'Enter your teamviewer ID', formControlName: 'meetingType' },
    {
      label: 'Confirm that this is your phone number:',
      formControlName: 'meetingType',
      placeholder: '+371 21 111 111',
    },
  ];

  public selectedMeetingType: string = null;
  public formGroup: FormGroup;

  public datetimes: any = [
    { time: '9.00 AM' },
    { time: '10.00 AM' },
    { time: '11.00 AM' },
    { time: '12.00 PM' },
    { time: '01.00 PM' },
  ];

  public kycTier = 1;
  public currentDate = new Date();
  public showDate = false;
  public selectedTime = 0;
  public selectedDate: any;

  @Input() public tierLimits: KycTierLimit[];

  constructor(private readonly formBuilder: FormBuilder) {
    this.formGroup = this.formBuilder.group({
      meetingType: [],
      meetingDate: [],
      meetingTime: [],
    });
  }

  myFilter = (d: Date): boolean => {
    const day = d.getDay();
    return day !== 0 && day !== 6;
  }

  public changeMeetingType(type: string): void {
    if (!type || type == null || this.selectedMeetingType === type) {
      return;
    }

    this.selectedMeetingType = type;
  }

  public onSelect(event: any): void {
    this.selectedDate = event;
    this.showDate = true;
  }

  public setTime(index: number): void {
    this.selectedTime = index;
  }

  public submit(): void {
  }
}
