import { Component, Input } from '@angular/core';
import { MatDialog } from '@angular/material/dialog';
import { DialogComponent } from '@app/shared/components/dialog-component/DialogComponent';
import { KycTierLimit } from '@app/shared/types/KycTierLimit';

@Component({
  selector: 'app-tier-gold',
  templateUrl: './tier-gold-component.html',
  styleUrls: ['./tier-gold-component.scss'],
})

export class TierGoldComponent {
  @Input() public tierLimits: KycTierLimit[];

  public kycTierLimitColumns: string[] = [
    'title',
    'day',
    'month',
    'annual'
  ];

  constructor(private readonly dialog: MatDialog) {
  }

  public payCommission(): void {
    const dialogRef = this.dialog.open(DialogComponent, {
      data: {
        type: 'kycGoldPayment',
        header: 'KYC level gold payment'
      },
      width: '45rem',
    });
  }
}
