import { Component, OnInit } from '@angular/core';
import { UserService } from '../../shared/services/UserService';
import { KycTierLimit } from '@app/shared/types/KycTierLimit';
import { Turnover } from '@app/shared/types/Turnover';
import { turnoverLimits, turnover} from './ProfileMockData';
import { HttpClient } from '@angular/common/http';

export interface UserInfoKVInterface {
  label: string;
  value: any;
  type?: string;
}

export interface UserDetailsKVInterface {
  label: string;
  value: any;
  type?: string;
}

@Component({
  selector: 'app-profile',
  templateUrl: './profile-component.html',
  styleUrls: ['./profile-component.scss'],
})
export class ProfileComponent implements OnInit {
  public userInfo: UserInfoKVInterface[] = [
    { label: 'First name', value: 'Unknown' },
    { label: 'Last name', value: 'Unknown'},
    { label: 'Email', value: 'Unknown' },
    { label: 'Birth date', value: new Date(), type: 'date' },
    { label: 'Country', value: 'Unknown' },
    { label: 'Phone number', value: 'Unknown' },
  ];

  public userDetails: UserDetailsKVInterface[] = [
    { label: 'Status:', value: 'Active' },
    { label: 'KYC level:', value: 'None' },
    { label: 'IP restriction:', value: 'Inactive' },
    { label: 'Prevoius login date:', value: new Date(), type: 'date' },
    { label: 'User ID:', value: 'Hidden' },
    { label: '2FA:', value: 'Inactive' },
    { label: 'Registered date:', value: new Date(), type: 'date' },
    { label: 'Email:', value: 'Verified' },
    { label: 'Recovery email:', value: 'Not set' },
    { label: 'Recovery phone:', value: 'Not set' },
  ];

  public statusColors: { [status: string]: string } = {
    CREATED: 'text-color-gray',
    PENDING: 'text-color-orange',
    VERIFIED: 'text-color-green',
    REJECTED: 'text-color-red',
    PAID: 'text-color-primary',
    IN_PROGRESS: 'text-color-primary',
  };

  public tierList: { tier: number, name: string, status?: string }[] = [
    { tier: 1, name: 'Silver'/*, status: 'VERIFIED'*/ },
    { tier: 2, name: 'Gold' },
    { tier: 3, name: 'Platinum' },
  ];

  public activeTier: number = null;
  public openedTier: any;
  public tierLimits: KycTierLimit[] = turnoverLimits;
  public userTurnovers: Turnover[] = turnover;

  public userTurnoverColumns = [
    'title',
    'day',
    'month',
    'annual',
    'alert'
  ];

  constructor(
    public readonly userService: UserService,
    private readonly httpClient: HttpClient
  ) {
  }

  ngOnInit(): void {
    this.refresh();
  }

  public refresh(): void {
    this.httpClient.get('/user/me').subscribe((data: any) => {
      const user = data.user;
      const profile = user.profile;
      const settings = data.settings;
      const lastLogin = data.lastLogin;

      this.userInfo = [
        { label: 'First name', value: profile.firstName ? profile.firstName : 'Unknown' },
        { label: 'Last name', value: profile.lastName ? profile.lastName : 'Unknown' },
        { label: 'Email', value: user.email ? user.email : 'Unknown' },
        { label: 'Birth date', value: profile.birthDate ? profile.birthDate : 'Unknown', type: 'date' },
        { label: 'Country', value: profile.country ? profile.country : 'Unknown' },
        { label: 'Phone number', value: profile.phoneNumber ? profile.phoneNumber : 'Unknown' },
      ];
      this.userDetails = [
        { label: 'Status:', value: 'Active' },
        { label: 'KYC level:', value: 'None' },
        { label: 'IP restriction:', value: 'Inactive' },
        { label: 'Prevoius login date:', value: lastLogin.created, type: 'date' },
        { label: 'User ID:', value: `${user.uuid}` },
        { label: '2FA:', value: 'Inactive' },
        { label: 'Registered date:', value: `${profile.created}`, type: 'date' },
        { label: 'Email:', value: 'Verified' },
        {
          label: 'Recovery email:',
          value: settings.recoveryEmail && settings.recoveryEmail.length > 0 ?
                    settings.recoveryEmail :
                    'Not set'
        },
        {
          label: 'Recovery phone:',
          value: settings.recoveryPhoneNumber && settings.recoveryPhoneNumber.length > 0 ?
                    settings.recoveryPhoneNumber :
                    'Not set'
        },
      ];
    });
  }
}
