import { NgModule } from '@angular/core';
import { Routes, RouterModule } from '@angular/router';
import { MarketComponent } from './components/market-component/market-component';
import { MarketPairChartComponent } from './components/market-pair-chart-component/market-pair-chart-component';

const routes: Routes = [
  // Module is lazy loaded, see app-routing.module.ts
  {
    path: '',
    redirectTo: 'market',
    pathMatch: 'full'
  },
  {
    path: '',
    component: MarketComponent,
  },
  {
    path: 'ohlc-chart/:base/:quote',
    component: MarketPairChartComponent,
  },
];
@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
  providers: []
})
export class MarketRoutingModule {}
