import { NgModule } from '@angular/core';
import { Routes, RouterModule } from '@angular/router';
import { MobileKeyComponent } from './mobile-key/MobileKeyComponent';
import { DesktopKeyComponent } from './desktop-key/DesktopKeyComponent';
import { HelpComponent } from './help/HelpComponent';
import { TermsConditionsComponent } from './terms-conditions/TermsConditionsComponent';
import { PrivacyPolicyComponent } from './privacy-policy/PrivacyPolicyComponent';

const routes: Routes = [
  // Module is lazy loaded, see app-routing.module.ts
  { path: '', redirectTo: 'mobile', pathMatch: 'full' },
  { path: 'mobile', component: MobileKeyComponent },
  { path: 'desktop', component: DesktopKeyComponent },
  { path: 'help', component: HelpComponent },
  { path: 'terms-conditions', component: TermsConditionsComponent },
  { path: 'privacy-policy', component: PrivacyPolicyComponent },
];
@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
  providers: [],
})
export class InformationRoutingModule { }
