import { HttpClient } from '@angular/common/http';
import { Component } from '@angular/core';
import { FormGroup, FormBuilder, Validators } from '@angular/forms';
import { Router } from '@angular/router';
import { SwalService } from '@app/shared/services/SwalService';
import { FormControlObject } from '@app/shared/types/FormFieldObject';

@Component({
  selector: 'app-forgot-password',
  templateUrl: './forgot-password-component.html',
  styleUrls: ['./forgot-password-component.scss'],
})
export class ForgotPasswordComponent {
  public forgotPasswordForm: FormGroup;

  public field: FormControlObject = {
    label: 'Email',
    formControlName: 'email'
  };

  public design = {
    header: 'no-bold',
    field: 'basic'
  };

  constructor(
    private readonly formBuilder: FormBuilder,
    private readonly router: Router,
    private readonly httpClient: HttpClient,
    private readonly swalService: SwalService
  ) {
    this.forgotPasswordForm = this.formBuilder.group({
      email: ['', [Validators.required, Validators.email]],
    });
  }

  public sendPasswordReset(): void {
    if (this.forgotPasswordForm.invalid) {
      return;
    }

    const formData: { email: string } = {
      email: this.forgotPasswordForm.get('email').value
    };

    this.httpClient.post('/user/password/forgot', formData).subscribe(res => {
      console.log(res);
      this.router.navigate(['/confirm-forgot-password'], { state: { email: formData.email } });
    },
    (error) => {
      this.swalService.showError({ title: 'Error', text: error.message });
    });
  }
}
