
import { HttpClient } from '@angular/common/http';
import { Component, OnInit } from '@angular/core';
import { ActivatedRoute, Router } from '@angular/router';
import { SwalService } from '@app/shared/services/SwalService';

@Component({
  selector: 'app-confirm-email',
  templateUrl: './confirm-email-component.html',
  styleUrls: ['./confirm-email-component.scss']
})
export class ConfirmEmailComponent implements OnInit {
  public code: string;
  public status = 'Hold on, we\'re confirming your email';
  constructor(
    private readonly router: Router,
    private readonly activatedRoute: ActivatedRoute,
    private readonly httpClient: HttpClient,
    private readonly swalService: SwalService
  ) {
  }

  ngOnInit(): void {
    this.confirmEmail();
  }

  private confirmEmail(): void {
    const code: { code: string } = {
      code: this.activatedRoute.snapshot.paramMap.get('code')
    };

    if (!code || code.code === null || code.code === '') {
      return;
    }

    this.httpClient.post('/user/email/confirmation/verify', code).subscribe(res => {
      this.status = 'Your email<br> has been successfuly confirmed';
      setTimeout(() => {
        this.router.navigateByUrl('/login');
      }, 5_000);
    }, (error) => {
      this.swalService.showError({ title: 'Error', text: error.message });
      this.router.navigateByUrl('/login');
    });
  }
}
