import { Routes, Route } from '@angular/router';
import { SimpleLayoutComponent } from './SimpleLayoutComponent';
import { EntryService } from '@app/shared/services/EntryService';

/**
 * Provides helper methods to create routes.
 */
export class SimpleLayoutService {
  /**
   * Creates routes using the shell component and authentication.
   * @param routes The routes to add.
   * @return The new route using shell as the base.
   */
  static childRoutes(routes: Routes): Route {
    return {
      path: '',
      component: SimpleLayoutComponent,
      children: routes,
      resolve: [
        EntryService
      ]
      // Reuse ShellComponent (MainLayoutComponent) instance when navigating between child views
      // data: { reuse: true }
    };
  }
}
