import { Component, AfterViewInit } from '@angular/core';
import { AppReadyEvent } from '@app/shared/AppReadyEvent';
import { EntryService } from '@app/shared/services/EntryService';
import { Router } from '@angular/router';
import { SwalService } from '@app/shared/services/SwalService';

@Component({
  selector: 'app-simple-layout',
  templateUrl: './simple-layout-component.html',
  styleUrls: ['./simple-layout-component.scss']
})
export class SimpleLayoutComponent implements AfterViewInit {
  constructor(
    private readonly appReadyEvent: AppReadyEvent,
    private readonly entryService: EntryService,
    private readonly router: Router,
    private readonly swalService: SwalService
    ) {
  }

  register(): void {
    if (!this.entryService.data.registrationEnabled) {
      this.swalService.showInfo({
        title: 'SWAL.REGISTRATION_DISABLED_TITLE',
        text: 'SWAL.REGISTRATION_DISABLED_TEXT',
        textParams: {
          param_value: this.entryService.data.registrationDisabledReason,
          timer: null
        }
      });
      return;
    }

    this.router.navigate(['/register']);
  }

  ngAfterViewInit(): void {
    setTimeout(() => {
        this.appReadyEvent.trigger();
    }, 500);
  }
}
