import { Routes, Route } from '@angular/router';
import { MainLayoutComponent } from './MainLayoutComponent';
import { AuthenticationGuard } from '@app/core/authentication/AuthenticationGuard';
import { AccountService } from '@app/shared/services/AccountService';
import { CurrencyService } from '@app/shared/services/CurrencyService';
import { TransactionService } from '@app/shared/services/TransactionService';
import { UserService } from '@app/shared/services/UserService';
import { TicketService } from '@app/shared/services/TicketService';
import { KycTierService } from '@app/shared/services/KycTierService';

/**
 * Provides helper methods to create routes.
 */
export class MainLayoutService {

  /**
   * Creates routes using the shell component and authentication.
   * @param routes The routes to add.
   * @return The new route using shell as the base.
   */
  static childRoutes(routes: Routes): Route {
    return {
      path: '',
      component: MainLayoutComponent,
      children: routes,
      canActivate: [AuthenticationGuard],
      resolve: {
        // tickets: TicketService,
        // accounts: AccountService,
        // currencies: CurrencyService,
        // transactions: TransactionService,
        // user: UserService,
        // kycTiers: KycTierService
      }
      // Reuse ShellComponent (MainLayoutComponent) instance when navigating between child views
      // data: { reuse: true }
    };
  }
}
