import { Resolve } from '@angular/router';
import { SocketSubServiceBase } from './SocketSubServiceBase';
import { SocketService } from './SocketService';
import { isEmpty } from '@app/shared/Helper';

export abstract class SocketSubServiceResolvable<T> extends SocketSubServiceBase implements Resolve<T>{
  constructor(
    protected readonly namespace: string,
    protected readonly socketService: SocketService,
    private readonly resolveOn?: string
  ) {
    super(namespace, socketService);
  }

  private resolved: T;

  public resolve(): Promise<T>{
    return new Promise((resolve, reject) => {
      if (this.resolved !== undefined || !isEmpty(this.resolved, true)){
        return resolve(this.resolved);
      }

      this.onEvent(this.resolveOn || 'data_loaded', (data) => {
        this.resolved = data;
        return resolve(data);
      }, true);

      const err = this.socketService.onError(() => {
        reject('socket_error');
        err.unsubscribe();
      });
    });
  }

  protected onClear(): void {
    this.resolved = undefined;
  }
}
