import { HttpErrorResponse, HttpEvent, HttpHandler, HttpInterceptor, HttpRequest } from '@angular/common/http';
import { Injectable, Injector } from '@angular/core';
import { Router } from '@angular/router';
import { environment } from '@env/environment';
import { Observable } from 'rxjs';
import { catchError } from 'rxjs/operators';
import { AuthenticationService } from '../authentication/AuthenticationService';
import { Logger } from '../LoggerService';

/**
 * Adds a default error handler to all requests.
 */
@Injectable()
export class ErrorHandlerInterceptor implements HttpInterceptor {
  private readonly logger = new Logger(ErrorHandlerInterceptor.name);

  constructor(
    private readonly injector: Injector
  ) {
  }

  intercept(request: HttpRequest<any>, next: HttpHandler): Observable<HttpEvent<any>> {
    return next.handle(request).pipe(catchError(error => this.errorHandler(error)));
  }

  // Customize the default error handler here if needed
  private errorHandler(response: HttpEvent<any>): Observable<HttpEvent<any>> {
    if (response instanceof HttpErrorResponse) {
      if (response.status === 401) {
        const authService = this.injector.get(AuthenticationService);
        const router = this.injector.get(Router);

        authService.logout().subscribe(res => {
          router.navigate(['/login']);
        });
      }
    }

    if (!environment.production) {
      // Do something with the error
      this.logger.error('Request error', response);
    }
    throw response;
  }
}
