import { Injectable } from '@angular/core';
import { ActivatedRouteSnapshot, CanActivate, Router, RouterStateSnapshot } from '@angular/router';
import { PermissionService } from '@app/shared/services/PermissionService';
import { SwalService } from '@app/shared/services/SwalService';

@Injectable()
export class AuthorizationGuard implements CanActivate {
    constructor(
        private readonly router: Router,
        private readonly permissionService: PermissionService,
        private readonly swalService: SwalService
    ) {
    }

    async canActivate(route: ActivatedRouteSnapshot, state: RouterStateSnapshot): Promise<boolean> {
        const restricted = route.data.restricted as string[];
        const restrictedIfAll = route.data.restrictedIfAll as string[];

        // if (!this.permissionService.isNotRestricted(restricted)) {
        //     return this.handlePermissionError();
        // }

        if (this.permissionService.isRestricted(restricted)) {
            return this.handlePermissionError();
        }

        if (this.permissionService.restrictedIfAll(restrictedIfAll)) {
            return this.handlePermissionError();
        }

        return true;
    }

    private handlePermissionError(): boolean {
        this.swalService.showError({ title: 'Permission Error', text: 'You don\'t have permission to open this!' });

        const defaultLink = this.permissionService.getDefaultRouterLink();
        this.router.navigate([defaultLink]);

        return false;
    }
}
