import { Injectable } from '@angular/core';
import { Observable, of, Observer } from 'rxjs';
import { Credentials, CredentialsService } from './CredentialsService';
import { HttpErrorResponse, HttpClient } from '@angular/common/http';
import { IdlerService } from '@app/shared/services/IdlerService';
import { MatDialog } from '@angular/material/dialog';

export interface LoginContext {
  email: string;
  password: string;
  remember?: boolean;
  deviceInfo?: any;
}

/**
 * Provides a base for authentication workflow.
 * The login/logout methods should be replaced with proper implementation.
 */
@Injectable()
export class AuthenticationService {
  private isUserAuthorized = false;

  constructor(
    private readonly credentialsService: CredentialsService,
    private readonly httpClient: HttpClient,
    private readonly idleService: IdlerService,
    private readonly dialog: MatDialog,
  ) {
  }

  /**
   * Authenticates the user.
   * @param context The login parameters.
   * @return The user credentials.
   */
  login(context: LoginContext): Observable<Credentials> {
    this.logout();

    // tslint:disable-next-line: deprecation
    return Observable.create((observer: Observer<any>) => {
      const body = {
        email: context.email,
        password: context.password,
        // deviceInfo: context.deviceInfo
      };

      return this.httpClient.disableAuthToken().post('/auth/login', body)
        .subscribe((response: any) => {
          const data = {
            email: context.email,
            token: response.access_token
          };

          this.credentialsService.setCredentials(data, context.remember);
          // this.socketService.connect(data.token);

          observer.next(data);
          observer.complete();
        }, error => {
          if (error instanceof HttpErrorResponse && error.status === 417) {
            observer.error(error);
          } else {
            // TODO: Commented now. Wha't the reason to filter these errors?
            // observer.error({ error: 'Server error' });
            observer.error(error);
          }
        });
    });
  }

  public async isAuthorized(): Promise<boolean> {
    if (!this.credentialsService.isAuthenticated()) {
      return false;
    }

    if (this.isUserAuthorized) {
      return true;
    }

    // try {
    //   const response = await this.httpClient.get<any>('/service/status').toPromise();
    //   const loggedIn = true;
    //   console.log('>>>>> ', JSON.stringify(response), loggedIn);
    //   if (!loggedIn) {
    //     this.logout();
    //     return false;
    //   }

    //   // this.permissionService.setPermissions(response.roles, response.permissions, response.restricted);

    //   // this.socketService.connect(this.credentialsService.credentials.token);
    //   this.idleService.startIdler();
    //   return true;
    // } catch (err) {
    //   console.error(err, err.stack);
    //   console.dir(err);
    //   return false;
    // }
    return true;
  }

  /**
   * Logs out the user and clear credentials.
   * @return True if the user was logged out successfully.
   */
  logout(): Observable<boolean> {
    // Customize credentials invalidation here
    this.credentialsService.setCredentials();
    // this.socketService.disconnect();
    this.idleService.stopIdler();
    this.dialog.closeAll();
    this.isUserAuthorized = false;
    return of(true);
  }
}
