import { NgModule, Optional, SkipSelf } from '@angular/core';
import { CommonModule } from '@angular/common';
import { HttpClient, HttpClientModule } from '@angular/common/http';
import { RouteReuseStrategy, RouterModule } from '@angular/router';
import { TranslateModule } from '@ngx-translate/core';
import { RouteReusableStrategy } from './RouteReusableStrategy';
import { AuthenticationService } from './authentication/AuthenticationService';
import { CredentialsService } from './authentication/CredentialsService';
import { AuthenticationGuard } from './authentication/AuthenticationGuard';
import { I18nService } from './I18nService';
import { HttpService } from './http/HttpService';
import { HttpCacheService } from './http/HttpCacheService';
import { ApiPrefixInterceptor } from './http/ApiPrefixInterceptor';
import { ErrorHandlerInterceptor } from './http/ErrorHandlerInterceptor';
import { CacheInterceptor } from './http/CacheInterceptor';
import { AuthTokenInterceptor } from './http/AuthTokenInterceptor';
import { SocketService } from './socket/SocketService';
import { AuthorizationGuard } from './authentication/AuthorizationGuard';

@NgModule({
  imports: [
    CommonModule,
    HttpClientModule,
    TranslateModule,
    RouterModule
  ],
  providers: [
    AuthenticationService,
    CredentialsService,
    SocketService,
    AuthenticationGuard,
    AuthorizationGuard,
    I18nService,
    HttpCacheService,
    ApiPrefixInterceptor,
    ErrorHandlerInterceptor,
    AuthTokenInterceptor,
    CacheInterceptor,
    {
      provide: HttpClient,
      useClass: HttpService
    },
    {
      provide: RouteReuseStrategy,
      useClass: RouteReusableStrategy
    }
  ]
})
export class CoreModule {
  constructor(@Optional() @SkipSelf() parentModule: CoreModule) {
    // Import guard
    if (parentModule) {
      throw new Error(`${parentModule} has already been loaded. Import Core module in the AppModule only.`);
    }
  }
}
