import { NgModule } from '@angular/core';
import { Routes, RouterModule, PreloadAllModules } from '@angular/router';
import { MainLayoutService } from './layout/main-layout/MainLayoutService';
import { SimpleLayoutService } from './layout/simple-layout/SimpleLayoutService';

const routes: Routes = [
  {
    path: '',
    redirectTo: 'wallets',
    pathMatch: 'full',
  },
  MainLayoutService.childRoutes([
    { path: 'wallets', loadChildren: () => import('app/pages/wallets/WalletsModule').then(m => m.WalletsModule)},
    { path: 'vault', loadChildren: () => import('app/pages/vault/VaultModule').then(m => m.VaultModule)},
    { path: 'security', loadChildren: () => import('app/pages/security/SecurityModule').then(m => m.SecurityModule)},
    { path: 'information', loadChildren: () => import('app/pages/information/InformationModule').then(m => m.InformationModule)},
    { path: 'profile', loadChildren: () => import('app/pages/profile/ProfileModule').then(m => m.ProfileModule)},
    { path: 'support', loadChildren: () => import('app/pages/support/SupportModule').then(m => m.SupportModule)},
    // { path: 'address-book', loadChildren: () => import('app/pages/address-book/AddressBookModule').then(m => m.AddressBookModule)},
    { path: 'transactions', loadChildren: () => import('app/pages/transactions/TransactionsModule').then(m => m.TransactionsModule)},
    { path: 'market', loadChildren: () => import('app/pages/market/MarketModule').then(m => m.MarketModule)},
  ]),
  SimpleLayoutService.childRoutes([
    { path: 'login', loadChildren: () => import('app/pages/login/LoginModule').then(m => m.LoginModule) },
    { path: 'register', loadChildren: () => import('app/pages/register/RegisterModule').then(m => m.RegisterModule) },
    // tslint:disable-next-line: max-line-length
    { path: 'forgot-password', loadChildren: () => import('app/pages/forgot-password/ForgotPasswordModule').then(m => m.ForgotPasswordModule) },
    { path: 'confirm-forgot-password', loadChildren: () => import('app/pages/forgot-password/confirm-forgot-password/ConfirmForgotPasswordModule').then(m => m.ConfirmForgotPasswordModule) },
    // tslint:disable-next-line: max-line-length
    { path: 'change-password/:code', loadChildren: () => import('app/pages/change-password/ChangePasswordModule').then(m => m.ChangePasswordModule) },
    { path: 'confirm-change-password', loadChildren: () => import('app/pages/change-password/confirm-change-password/ConfirmChangePasswordModule').then(m => m.ConfirmChangePasswordModule) },
    // tslint:disable-next-line: max-line-length
    { path: 'confirm-email/:code', loadChildren: () => import ('app/pages/confirm-email/ConfirmEmailModule').then(m => m.ConfirmEmailModule)}
  ]),
  // Fallback when no prior route is matched
  { path: '**', redirectTo: '/wallets', pathMatch: 'full' }
];

@NgModule({
  imports: [RouterModule.forRoot(routes, { preloadingStrategy: PreloadAllModules })],
  exports: [RouterModule],
  providers: []
})
export class AppRoutingModule { }
