import { BrowserModule } from '@angular/platform-browser';
import { NgModule } from '@angular/core';
import { FormsModule } from '@angular/forms';
import { HttpClientModule } from '@angular/common/http';
import { BrowserAnimationsModule } from '@angular/platform-browser/animations';
import { MaterialModule } from './MaterialModule';
import { CoreModule } from '@app/core/CoreModule';
import { AppComponent } from './AppComponent';
import { AppRoutingModule } from './AppRoutingModule';
import { MainLayoutModule } from './layout/main-layout/MainLayoutModule';
import { SimpleLayoutModule } from './layout/simple-layout/SimpleLayoutModule';
import { SweetAlert2Module } from '@sweetalert2/ngx-sweetalert2';
import { SharedModule } from './shared/SharedModule';
import { ClipboardModule } from 'ngx-clipboard';
import { MatMomentDateModule, MAT_MOMENT_DATE_ADAPTER_OPTIONS } from '@angular/material-moment-adapter';
import { Angulartics2Module } from 'angulartics2';
import { TranslateModule } from '@ngx-translate/core';
import { NgxDaterangepickerMd } from 'ngx-daterangepicker-material';
import { ChartsModule } from 'ng2-charts';

@NgModule({
  imports: [
    FormsModule,
    NgxDaterangepickerMd.forRoot(),
    BrowserModule,
    HttpClientModule,
    TranslateModule.forRoot(),
    BrowserAnimationsModule,
    MaterialModule,
    MatMomentDateModule,
    CoreModule,
    ClipboardModule,
    SweetAlert2Module.forRoot(),
    SharedModule.forRoot(),
    SimpleLayoutModule,
    MainLayoutModule,
    AppRoutingModule, // must be imported as the last module as it contains the fallback route
    Angulartics2Module.forRoot(),
    ChartsModule
  ],
  declarations: [AppComponent],
  providers: [
    { provide: MAT_MOMENT_DATE_ADAPTER_OPTIONS, useValue: { useUtc: true } },
    // { provide: MAT_DATE_LOCALE, useValue:'en-GB' }
  ],
  bootstrap: [AppComponent]
})
export class AppModule { }
