#!/bin/bash

npm run ng-high-memory

# Build project source
if [ "$ENVIRONMENT" == "local" ] || [ "$ENVIRONMENT" == "test" ]; then

    echo "Starting project in development mode"
    npm start

else
    ng build -c "$ENVIRONMENT"

    # Copy dist folder to nging folder
    echo "Copying dist source to www folder"
    cp -R /usr/src/app/dist/* /var/www/html

    echo "Running nginx with daemon off"
    nginx -g 'daemon off;'
fi
