// @ts-check
// Note: type annotations allow type checking and IDEs autocompletion

const lightCodeTheme = require('prism-react-renderer/themes/github');
const darkCodeTheme = require('prism-react-renderer/themes/dracula');

/** @type {import('@docusaurus/types').Config} */
const config = {
  title: 'dVITA Documentation',
  tagline: '',
  url: 'https://dvita.io',
  baseUrl: '/documentation/',
  onBrokenLinks: 'throw',
  onBrokenMarkdownLinks: 'warn',
  favicon: 'img/logo.png',

  // GitHub pages deployment config.
  // If you aren't using GitHub pages, you don't need these.
  organizationName: 'dVita-Labs', // Usually your GitHub org/user name.
  projectName: 'dvita-documentation', // Usually your repo name.

  // Even if you don't use internalization, you can use this field to set useful
  // metadata like html lang. For example, if your site is Chinese, you may want
  // to replace "en" with "zh-Hans".
  i18n: {
    defaultLocale: 'en',
    locales: ['en'],
  },

  presets: [
    [
      '@docusaurus/preset-classic',
      /** @type {import('@docusaurus/preset-classic').Options} */
      ({
        docs: {
          routeBasePath: '/', 
          sidebarPath: require.resolve('./sidebars.js')
        },
        blog: false,
        theme: {
          customCss: require.resolve('./src/css/custom.css'),
        },
      }),
    ],
  ],

  themeConfig:
    /** @type {import('@docusaurus/preset-classic').ThemeConfig} */
    ({
      navbar: {
        title: 'dVITA Documentation',
        logo: {
          alt: 'Site Logo',
          src: 'img/logo.png',
          target: '_self',
          width: 32,
          height: 32,
          className: 'custom-navbar-logo-class',
          }
      },
      footer: {
        style: 'dark',
        links: [
              {
                label: 'dVITA Portal',
                href: 'https://dvita.io/',
              },
              {
                label: 'Wallet plugin',
                href: 'https://chrome.google.com/webstore/detail/dvita-wallet/kgencbnkhikeeaankpdmdonofefodadd?hl=en-GB&authuser=0',
              },
              {
                label: 'GitHub',
                href: 'https://github.com/dVita-Labs',
              }
            ],
        copyright: `Copyright © ${new Date().getFullYear()}, dVITA.labs, All rights reserved`,
      },
      prism: {
        theme: lightCodeTheme,
        darkTheme: darkCodeTheme,
      },
    }),
};

module.exports = config;
