---
sidebar_position: 2
---

# Node configuration

Options available to configure:

|Key                        |Values                                |Default Value                |Comments                                       |
|:--------------------------|:-------------------------------------|:----------------------------|:----------------------------------------------|
|Logger_Active              |true/false                            |true                         |Enable app logging inside a node               |
|P2P_Port_TCP               |numeric                               |20333                        |TCP port for P2P Protocol                      |
|P2P_Port_WS                |numeric                               |20334                        |Web Socket http port for P2P Protocol          |
|RPC_Port                   |numeric                               |20332                        |RPC http port                                  |
|RPC_Bind_Address           |string host name/ip                   |127.0.0.1                    |Local RPC http host to bind to                 |
|Wallet_Path                |string                                |/dvita-node-data/wallet.json |Wallet file storage path                       |
|Wallet_Password            |string                                |                             |Password to access wallet                      |
|Protocol_Network_Id        |string                                |199                          |Network identifier                             |
|Protocol_Validators_Count  |numeric                               |4                            |Number of consensus nodes                      |
|Protocol_Standby_Committee |Comma-separated list                  |                             |Genesis block Foundation members               |
|Protocol_Seed_List         |Comma-separated list of the DNS names |                             |Seed node DNS Addresses used for P2P discovery |

Use a custom config file. Create a config file and get it into the container. If you need a starting place for your config file you can use the sample provided at https://github.com/dVita-Labs/dvita-node-infra/blob/master/NXA/config/testnet/public/config.json