---
sidebar_position: 6
---

# Troubleshooting

### Diagnosing Problems
Collect information to identify the cause of problems.

If you are having problems with dVITA node, the first step is to collect more information to accurately characterize the problem. From there, it can be easier to figure out a root cause and a fix.

To see the current status of blockchain synchronization:

``` show state ```

To check current CLI version:

``` version ```

To list loaded plugins:

``` plugins ```

### Node Doesn't Sync

First Step: Restart
Many syncing issues can be resolved by restarting the node. No matter why it failed to sync the first time, it may succeed on the second try. Optionally, restart the entire machine.


**The most common cause of syncing issues is not meeting the system requirements. The four most common shortfalls are:**

**Slow disks.** You need a consistently fast solid state disk (SSD). Cloud providers like AWS usually don't guarantee disk performance, which may be impacted by other users of shared hardware.

**Insufficient disk.** If you don’t have at least 500 GB free disk space, it can prevent node from downloading incoming blocks.

**Insufficient RAM.** The memory requirements vary depending on several factors including ones that are hard to predict like network load, so it's good to have more than the minimum system requirements.

**Poor network connection.** A slow or unstable connection can make it impossible to keep up with new transactions.

If you are having trouble remaining synced, double-check that your server meets the system requirements. Depending on how you use your server, you may need to meet the higher "Recommended" requirements.

### OpenAPI does not connect to the utility node

**Check if the utility node endpoint is configured correctly in OpenAPI .env file.**

Navigate to OpenApi .env file and check if ``` BLOCKCHAIN_RPC_ENDPOINT ``` is set to your utility node instance, previously run by:

```
# For testnet
docker run --name dvita-testnet-node -d -e "NODE_TYPE=utility" -v dvita-node-data:/dvita-node-data -p 20332-20334:20332-20334 registry.team11.lv/public/dvita-testnet-node:latest
```

If not, try running the utility node or changing ```BLOCKCHAIN_RPC_ENDPOINT``` value to ```http://localhost:20332```.

**Useful links:**
Block explorer: https://dvita.io/blocks
dVITA Labs GitHub: https://github.com/dVita-Labs

Can't find what you're looking for? Send an email to **admin@dvita.io**