---
sidebar_position: 2
---

# Security

## Authentication
Store the private key in a secure, offline, and recoverable location, such as an encrypted USB flash drive.

## Physical
This is a non-exhaustive checklist of security considerations. These points should be considered when making a choice of server location and determining if the location will offer sufficient security. 

* 24/7 physical security guards.

* Operational management of security.

* Access restrictions to the facility (property).

* Access restrictions to the machines (even for those who can enter the property).

* Sufficient cooling.

* Power redundancy.

* High throughput connectivity.

The node should not run on any cloud provider.

## Crypto volumes
When using Linux as a Host system for the Docker images consider to use Crypto FS + LVM.

<details>

<summary> Encrypt LVM Volumes </summary>

```markdown
sudo apt install cryptsetup -y

sudo cryptsetup luksFormat --hash=sha512 --key-size=512 --cipher=aes-xts-plain64 --verify-passphrase /dev/sdc

cryptsetup luksOpen /dev/sdc crypt_sdc
```

</details>

## Operating System
The following distros are recommended: [Debian](https://www.debian.org/), [Ubuntu](https://www.ubuntu.com/), [RH](https://www.redhat.com/en)

### Linux Best Practices

* Never use the root user.

* Always update the security patches for your OS.

* Enable and set up a firewall.

* Never allow password-based SSH, only use key-based access.

* Disable non-essential OS subsystems like * motd, scp, telnet, ftp, X11 forwarding*.

* Harden your SSH configuration.

* Back up your storage regularly including persistent docker volumes.

## Firewall
To avoid the significant security risk, a whitelist or firewall must be used to block external server requests. For security reasons, the Wallet Nodes should be run in an independent server on which the firewall is configured properly, as shown below.

| Service             | Main Net port       |   Test Net port     |
|:-----------         |:------------------- |:------------------  |
| JSON-RPC via HTTPS  | 10331               |   20331             |
| JSON-RPC via HTTP   | 10332               |   20332             |
| P2P via TCP         | 10333               |   20333             |
| P2P via WebSocket   | 10334               |   20334             | 
