---
sidebar_position: 4
---

# Running node

### Sync From Genesis Block
#### 1. Start Partner node 

**Docker**

If you have Docker installed, you can use it to start your node without needing to build the binary. You can do this with a simple one line command:

```
# For testnet
docker run --name dvita-testnet-node -d -e "NODE_TYPE=partner" -v dvita-node-data:/dvita-node-data -p 20332-20334:20332-20334 registry.team11.lv/public/dvita-testnet-node:latest
```

#### 2. Open node console

```
docker ps
docker exec -it dvita-testnet-node bash
screen -r 1
```

#### 3. Check node connection

```
show state
```
It should show the node syncing: 

```
block: 32111/42000  connected: 4  unconnected: 0
  ip: 13.49.1.31            port: 22333 listen: 20333       height: 965542
  ip: 13.49.1.31            port: 21333 listen: 20333       height: 965542
  ip: 13.49.1.31            port: 24333 listen: 20333       height: 965542
  ip: 13.51.209.234         port: 20333 listen: 20333       height: 965542
```

 At any time you can monitor node status using this command.

#### 4. Wait for node to sync​
Your node should now be catching up with the network by replaying all the transactions from genesis and recreating the blockchain state locally. This will take a long time, so make sure you've set it up on a stable connection so you can leave while it syncs.

#### 5. Register as a candidate
5.1 Contact us and request 1000.1 DVP to your wallet address.

5.2 Register the candidate by using this command:

```
register candidate <account>
```

**account**: Your address, you can find it by running the ``` list key ``` command.