---
sidebar_position: 3
---

# Node configuration

#### Refer your config file at this location: 

/dvita-node/config.json

#### Edit the config file, modifying the following sections:

| Key                           | Values                   |  Default Value                 |   Comments                                                                                        |
|:------------------------------|:------------------------ |:-------------------------------|:--------------------------------------------------------------------------------------------------|
| UnlockWallet/Path             | string                   |   /dvita-node-data/wallet.json |   Leave as is                                                                                     |
| UnlockWallet/Password         | string                   |   empty                        |   Provide password to access wallet from the **“Wallet creation“** step                           |
| UnlockWallet/IsActive         | true/false               |   true                         |   Set active wallet                                                                               |
| UnlockWallet/StartConsensus   | true/false               |  **false**                     |   Set to **true** to start consensus                                                              |
| Logger/Path                   | string                   |   	"/dvita-node-data/Logs_{0}" |   Path to log files                                                                               |
| Logger/Active                 | true/false               |   true                         |   Turn logger on/off                                                                              |
| Logger/ConsoleOutput          | true/false               |   true                         |   Show logger output in CLI                                                                       |
| RPC  | string                 |"RPC": {<br />"BindAddress": "127.0.0.1",<br />"Port": 20332,<br />"SslCert": "",<br />"SslCertPassword": "" },<br /> |Remove this section to disable RPC      |

#### Refer your DvitaExtendedRPC config file at this location: 
/dvita-node/Plugins/DvitaExtendedRPC/config.json

#### Edit the config file, modifying the following sections:

| Key               | Values       |  Default Value      |   Comments                                                                |
|:------------------|:-------------|:--------------------|:--------------------------------------------------------------------------|
| Active            | true/false   |   **false**         |   DvitaExtendedRPC sould be turned off by setting this value to false.    |

#### Refer your RpcServer config file at this location: 
/dvita-node/Plugins/RpcServer/config.json

#### Edit the config file, modifying the following sections:

| Key               | Values                  |  Default Value    |   Comments                                                         |
|:------------------|:------------------------|:------------------|:-------------------------------------------------------------------|
| SessionEnabled    | true/false              |   empty           |   RpcServer sould be turned off by setting this value to false.    |

#### Refer your OracleService config file at this location: 
/dvita-node/Plugins/OracleService/config.json

#### Edit the config file, modifying the following sections:

| Key        | Values                   |  Default Value    |   Comments                                                             |
|:-----------|:------------------------ |:------------------|:-----------------------------------------------------------------------|
| AutoStart  | true/false               |   **false**       |   OracleService sould be turned off by setting this value to false.    |

#### Refer your DvitaBlockListener config file at this location: 
/dvita-node/Plugins/DvitaBlockListener/config.json

#### Edit the config file, modifying the following sections:

| Key        | Values                   |  Default Value    |   Comments                                                                 |
|:-----------|:------------------------ |:------------------|:---------------------------------------------------------------------------|
| Active     | true/false               |   empty           |   DvitaBlockListener sould be turned off by setting this value to false.   |

#### Refer your DBFTPlugin config file at this location: 
/dvita-node/Plugins/DBFTPlugin/config.json

#### Edit the config file, modifying the following sections:

| Key        | Values                   |  Default Value    |   Comments                                                                            |
|:-----------|:------------------------ |:------------------|:--------------------------------------------------------------------------------------|
| AutoStart  | true/false               |   **false**       |   Set AutoStart to **true** so as to automatically start consensus as running Node.   |

#### Wallet creation
```
create wallet /dvita-node-data/wallet.json
# input a password for the wallet
```