---
sidebar_position: 2
---

# Development environment setup
#### Clone all following repositories inside one directorly like:
```
mkdir -p ~/projects/dvita-project
cd dvita-project
git clone https://github.com/dVita-Labs/dvita-node-infra.git
git clone https://github.com/dVita-Labs/dvita-virtual-machine.git
git clone https://github.com/dVita-Labs/dvita-blockchain-core.git
git clone https://github.com/dVita-Labs/dvita-blockchain-modules.git
git clone https://github.com/dVita-Labs/dvita-blockchain-node.git
git clone https://github.com/dVita-Labs/dvita-blockchain-ext-modules.git
git clone https://github.com/dVita-Labs/dvita-dev-solution.git
```

#### Build: 
```
# Pre-build modules
cd neo-modules
make build

# Build node
cd ../neo-node/neo-cli
make build

# Copy binary deps
cp ../dvita-dev-solution/libleveldb.dll ./

# Install default modules that have been build above
mkdir ./dist/Plugins
cp -a ../../neo-modules/dist/* dist/Plugins

# Remove 'Storage' and 'Logger' sections
vim dist/config.json

# Run it locally
dotnet dist/neo-cli.dll
```