---
sidebar_position: 3
---

# How to perform Blockchain transactions

## Using dVITA Foundation Framework

Code examples for [dVITA Foundation Framework](https://github.com/dVita-Labs/dvita-foundation-framework) usage can be found: 
* **C#** https://github.com/dVita-Labs/dvita-foundation-framework/blob/main/cs/README.md
* **TypeScript** https://github.com/dVita-Labs/dvita-foundation-framework/blob/main/node/nest/README.md


## Using wallet plugin and node CLI

#### 1. Install wallet plugin and generate new address [A]

* Git clone https://github.com/dVita-Labs/dvita-wallet-plugin
* Run npm install to install dependencies.
* Run npm run build to build release assets for chrome extension debug.
* Open google chrome manage extensions page chrome://extensions/
* Turn on developer mode
* Drag & drop dvita-wallet-plugin dist folder 
* Create wallet through installed Chrome plugin

**or**

* Download and install the wallet plugin through https://chrome.google.com/webstore/detail/dvita-wallet/kgencbnkhikeeaankpdmdonofefodadd?hl=en-GB&authuser=0
* Create wallet through installed Chrome plugin


#### 2. Run node instance and create wallet [B] through node CLI

* Run node following instructions described on [How to run dVITA node instances](/public-node/running-node)
* Inside node CLI create wallet:
```
create wallet wallet.json
```
and input a password for the wallet

* Returned values: 
```
Address: NQD93fVJqr5YLm7jYZaVnPQbsXPc7jFzpv
Pubkey: 025999b89e08b0bcaf4dbb5a82180dba7ffbd1d51000c71c7a2103ac35b2968d15
ScriptHash: 0x458de6187b6347b9bbc905b605c99f5c3cce1f2f
DVT hash: 0xb34e1025391e953a918231df11478ec21b039e5f
DVP hash:   0xd2a4cff31913016155e38e474a2c06d08be276cf
```

#### 3. Deposit DVT and DVP to [A] via https://dvita.io/ 

#### 4. Send [A] → [B] DVP and DVT

Using wallet plugin, transfer chosen amount to ```NQD93fVJqr5YLm7jYZaVnPQbsXPc7jFzpv```

#### 5. Check [B] balance 

**a.** Using list asset command

In CLI type ```list asset```

**b.** Using balanceof command

For DVT balance ```balanceof 0xb34e1025391e953a918231df11478ec21b039e5f NQD93fVJqr5YLm7jYZaVnPQbsXPc7jFzpv```

or ```balanceof DVT NQD93fVJqr5YLm7jYZaVnPQbsXPc7jFzpv```

 For DVP balance ```balanceof 0xd2a4cff31913016155e38e474a2c06d08be276cf NQD93fVJqr5YLm7jYZaVnPQbsXPc7jFzpv```

**c.** Through smart contract invocation

Parse address 
```
parse NQD93fVJqr5YLm7jYZaVnPQbsXPc7jFzpv
```

To get values
```
Address to ScriptHash           0x458de6187b6347b9bbc905b605c99f5c3cce1f2f
Address to Base64               Lx/OPFyfyQW2Bcm7uUdjexjmjUU=
String to Hex String            4e5144393366564a717235594c6d376a595a61566e50516273585063376a467a7076
String to Base64                TlFEOTNmVkpxcjVZTG03allaYVZuUFFic1hQYzdqRnpwdg==
```
Run
```
invoke 0xb34e1025391e953a918231df11478ec21b039e5f balanceOf [{"type":"ByteArray","value":"Lx/OPFyfyQW2Bcm7uUdjexjmjUU="}]
```
or 
```
invoke 0xb34e1025391e953a918231df11478ec21b039e5f balanceOf [{"type":"Hash160","value":"0x458de6187b6347b9bbc905b605c99f5c3cce1f2f"}]
```

#### 6. Destroy [A] and [B] and restore/reimport them again

For [A]

* Open Chrome plugin
* Account details
* Show Private Key
* Save Private Key
* Remove account
* Import an existing wallet
* Input wallet name, Private Key and password

For [B]

* In CLI type ```close wallet```
* ```open wallet wallet.json```
* Input password
* ```import key <Private key>```
* To get Address, ScriptHash and PublicKey, use ```list key``` command

#### 7. Compile and deploy token through CLI 

* Create Smart Contract
* Compile it using PUT https://caas.testnet.dvita.com/api/Compiler or Neo.Compiler.CSharp
* Create sc directory
* **TokenName.nef** and **TokenName.manifest.json** into sc directory
* Copy this directory inside docker container ```docker cp ./sc dvita-testnet-node:sc```
* Run deploy command inside node CLI ```deploy ../sc/TokenName.nef ../sc/TokenName.manifest.json```

and as a response get ```Contract hash: 0x1c6c0fb668ca7282601c7891416dcdaaf2e41ae1```

#### 8. Interact with this contract

To check owners balance (in this case owner is wallet [A])

```
invoke 0x1c6c0fb668ca7282601c7891416dcdaaf2e41ae1 balanceOf [{"type":"ByteArray","value":"VG+BzgJJ6nloPjmnqMntguZhS/o="}]
Result Stack: [{"type":"Integer","value":"1000000"}]
```

Mint additional 2000000 coins to wallet [A]

```
invoke 0x1c6c0fb668ca7282601c7891416dcdaaf2e41ae1 mint [{"type":"ByteArray","value":"VG+BzgJJ6nloPjmnqMntguZhS/o="},{"type":"Integer","value":"2000000"}] NTcRXWqsRbR3XqtZWWVunxV7CGph27dMAY
```

Check total coin supply after minting additional coins 

```
invoke 0x1c6c0fb668ca7282601c7891416dcdaaf2e41ae1 totalSupply
Result Stack: [{"type":"Integer","value":"3000000"}]
```

Burn 1000000 coins

```
invoke 0x1c6c0fb668ca7282601c7891416dcdaaf2e41ae1 burn [{"type":"ByteArray","value":"VG+BzgJJ6nloPjmnqMntguZhS/o="},{"type":"Integer","value":"1000000"}] NTcRXWqsRbR3XqtZWWVunxV7CGph27dMAY
```

Check total coin supply after burning 1000000 coins

```
invoke 0x1c6c0fb668ca7282601c7891416dcdaaf2e41ae1 totalSupply
Result Stack: [{"type":"Integer","value":"2000000"}]
```

Update the contract:

* if contracts update methods input parameters are : ```public static bool Update(ByteString nefFile, string manifest)```

```
update 0x1c6c0fb668ca7282601c7891416dcdaaf2e41ae1 ../sc/Team11Token.nef ../sc/Team11Token.manifest.json NTcRXWqsRbR3XqtZWWVunxV7CGph27dMAY NTcRXWqsRbR3XqtZWWVunxV7CGph27dMAY
```

* if contracts update methods input parameters are : ```public static bool Update(ByteString nefFile, string manifest, object data = null)``` then additional parameter needed 

```
update 0x1c6c0fb668ca7282601c7891416dcdaaf2e41ae1 ../sc/Team11Token.nef ../sc/Team11Token.manifest.json NTcRXWqsRbR3XqtZWWVunxV7CGph27dMAY NTcRXWqsRbR3XqtZWWVunxV7CGph27dMAY {"type":"Any","value":null}
```

#### 9. Using new partner on premises instances [C] and [D] create Multisig address [M] 

Repeat step 2 to run nodes and create wallets for them

In this example wallet [C]

```
Address: Nb92Je2NHHqSrX85aaqoCU1ikShECBjZPk
Pubkey: 0332f47bda0f5a23e5575ca81701958b39eb8065c857e200c6e981c3c57f1c9112
ScriptHash: 0x1fb6dedcc8aaa32e29c9b05ceec67114c9e501a7
```

wallet [D]

```
Address: NT8xUgtm9BUtWyVrAoqt6JJ3VupKZ4dWbi
Pubkey: 035ff6493211c6f84e7edfed87cfca4cc36c1454fc6f56120bc76aab1456febcb5
ScriptHash: 0xc1b656fcad6fce13ccf06ec1971417356ab23d4f
```

Run this command on both wallets [C] and [D]

```
import multisigaddress 2 0332f47bda0f5a23e5575ca81701958b39eb8065c857e200c6e981c3c57f1c9112 035ff6493211c6f84e7edfed87cfca4cc36c1454fc6f56120bc76aab1456febcb5
```

And get [M] address value as a response 

```
Multisig. Addr.: NcPAULw7tuad8eKzQ1fnFZg4jbHrGa8SAZ
```

**a.** Deposit [A] → [M]

Follow step 4. to address ```NcPAULw7tuad8eKzQ1fnFZg4jbHrGa8SAZ```

**b.** Withdraw [M] → [B] 

Run send command inside wallet [D]

```
send 0xb34e1025391e953a918231df11478ec21b039e5f NQD93fVJqr5YLm7jYZaVnPQbsXPc7jFzpv 2 NcPAULw7tuad8eKzQ1fnFZg4jbHrGa8SAZ null NcPAULw7tuad8eKzQ1fnFZg4jbHrGa8SAZ
```
or

```
send DVT NQD93fVJqr5YLm7jYZaVnPQbsXPc7jFzpv 2 NcPAULw7tuad8eKzQ1fnFZg4jbHrGa8SAZ null NcPAULw7tuad8eKzQ1fnFZg4jbHrGa8SAZ
```

And get as a response 

```
Incomplete signature:
{"type":"Neo.Network.P2P.Payloads.Transaction","hash":"0x31782ba202f5730d786f6c15e912a4abf9cc92c7c31ab71a889ce6c938ccd5ac","data":"AKWV0nqGQJgAAAAAAORmIwAAAAAA1b0EAAG0pqoi4/IAuU2itcwjHb3gV\u002B/CfwEAXAwEbnVsbBIMFC8fzjxcn8kFtgXJu7lHY3sY5o1FDBS0pqoi4/IAuU2itcwjHb3gV\u002B/CfxTAHwwIdHJhbnNmZXIMFF\u002BeAxvCjkcR3zGCkTqVHjklEE6zQWJ9W1I5","items":{"0x7fc2ef57e0bd1d23ccb5a24db900f2e322aaa6b4":{"script":"EgwhAzL0e9oPWiPlV1yoFwGViznrgGXIV\u002BIAxumBw8V/HJESDCEDX/ZJMhHG\u002BE5\u002B3\u002B2Hz8pMw2wUVPxvVhILx2qrFFb\u002BvLUSQZ7Q3Do=","parameters":[{"type":"Signature"},{"type":"Signature"}],"signatures":{"035ff6493211c6f84e7edfed87cfca4cc36c1454fc6f56120bc76aab1456febcb5":"5b9TDz0t/n3okWuD4G/qVsrzW0rwg5Oj9/d4bsgyaSuc4B00f9MSKJ9VyWKIPOqTLQqzTv/tzD4S3bwhZQYl1A=="}}},"network":199}
```

Run sign command inside wallet [C] using send commands response as argument

```
sign {"type":"Neo.Network.P2P.Payloads.Transaction","hash":"0x31782ba202f5730d786f6c15e912a4abf9cc92c7c31ab71a889ce6c938ccd5ac","data":"AKWV0nqGQJgAAAAAAORmIwAAAAAA1b0EAAG0pqoi4/IAuU2itcwjHb3gV\u002B/CfwEAXAwEbnVsbBIMFC8fzjxcn8kFtgXJu7lHY3sY5o1FDBS0pqoi4/IAuU2itcwjHb3gV\u002B/CfxTAHwwIdHJhbnNmZXIMFF\u002BeAxvCjkcR3zGCkTqVHjklEE6zQWJ9W1I5","items":{"0x7fc2ef57e0bd1d23ccb5a24db900f2e322aaa6b4":{"script":"EgwhAzL0e9oPWiPlV1yoFwGViznrgGXIV\u002BIAxumBw8V/HJESDCEDX/ZJMhHG\u002BE5\u002B3\u002B2Hz8pMw2wUVPxvVhILx2qrFFb\u002BvLUSQZ7Q3Do=","parameters":[{"type":"Signature"},{"type":"Signature"}],"signatures":{"035ff6493211c6f84e7edfed87cfca4cc36c1454fc6f56120bc76aab1456febcb5":"5b9TDz0t/n3okWuD4G/qVsrzW0rwg5Oj9/d4bsgyaSuc4B00f9MSKJ9VyWKIPOqTLQqzTv/tzD4S3bwhZQYl1A=="}}},"network":199}
```

Get a response

```
Signed Output:
{"type":"Neo.Network.P2P.Payloads.Transaction","hash":"0x31782ba202f5730d786f6c15e912a4abf9cc92c7c31ab71a889ce6c938ccd5ac","data":"AKWV0nqGQJgAAAAAAORmIwAAAAAA1b0EAAG0pqoi4/IAuU2itcwjHb3gV\u002B/CfwEAXAwEbnVsbBIMFC8fzjxcn8kFtgXJu7lHY3sY5o1FDBS0pqoi4/IAuU2itcwjHb3gV\u002B/CfxTAHwwIdHJhbnNmZXIMFF\u002BeAxvCjkcR3zGCkTqVHjklEE6zQWJ9W1I5","items":{"0x7fc2ef57e0bd1d23ccb5a24db900f2e322aaa6b4":{"script":"EgwhAzL0e9oPWiPlV1yoFwGViznrgGXIV\u002BIAxumBw8V/HJESDCEDX/ZJMhHG\u002BE5\u002B3\u002B2Hz8pMw2wUVPxvVhILx2qrFFb\u002BvLUSQZ7Q3Do=","parameters":[{"type":"Signature","value":"5b9TDz0t/n3okWuD4G/qVsrzW0rwg5Oj9/d4bsgyaSuc4B00f9MSKJ9VyWKIPOqTLQqzTv/tzD4S3bwhZQYl1A=="},{"type":"Signature","value":"BA01GjnaAL3XXfb112a/aPXD3gWd0UUmKKyR1Pt\u002BhOGd13X2/2Ck1ybcjGxqrQiZZO\u002BvT571hclviOn9oS5XRQ=="}],"signatures":{"035ff6493211c6f84e7edfed87cfca4cc36c1454fc6f56120bc76aab1456febcb5":"5b9TDz0t/n3okWuD4G/qVsrzW0rwg5Oj9/d4bsgyaSuc4B00f9MSKJ9VyWKIPOqTLQqzTv/tzD4S3bwhZQYl1A==","0332f47bda0f5a23e5575ca81701958b39eb8065c857e200c6e981c3c57f1c9112":"BA01GjnaAL3XXfb112a/aPXD3gWd0UUmKKyR1Pt\u002BhOGd13X2/2Ck1ybcjGxqrQiZZO\u002BvT571hclviOn9oS5XRQ=="}}},"network":199}
```

Run relay command inside wallet [C] using sign commands response as argument

```
relay {"type":"Neo.Network.P2P.Payloads.Transaction","hash":"0x31782ba202f5730d786f6c15e912a4abf9cc92c7c31ab71a889ce6c938ccd5ac","data":"AKWV0nqGQJgAAAAAAORmIwAAAAAA1b0EAAG0pqoi4/IAuU2itcwjHb3gV\u002B/CfwEAXAwEbnVsbBIMFC8fzjxcn8kFtgXJu7lHY3sY5o1FDBS0pqoi4/IAuU2itcwjHb3gV\u002B/CfxTAHwwIdHJhbnNmZXIMFF\u002BeAxvCjkcR3zGCkTqVHjklEE6zQWJ9W1I5","items":{"0x7fc2ef57e0bd1d23ccb5a24db900f2e322aaa6b4":{"script":"EgwhAzL0e9oPWiPlV1yoFwGViznrgGXIV\u002BIAxumBw8V/HJESDCEDX/ZJMhHG\u002BE5\u002B3\u002B2Hz8pMw2wUVPxvVhILx2qrFFb\u002BvLUSQZ7Q3Do=","parameters":[{"type":"Signature","value":"5b9TDz0t/n3okWuD4G/qVsrzW0rwg5Oj9/d4bsgyaSuc4B00f9MSKJ9VyWKIPOqTLQqzTv/tzD4S3bwhZQYl1A=="},{"type":"Signature","value":"BA01GjnaAL3XXfb112a/aPXD3gWd0UUmKKyR1Pt\u002BhOGd13X2/2Ck1ybcjGxqrQiZZO\u002BvT571hclviOn9oS5XRQ=="}],"signatures":{"035ff6493211c6f84e7edfed87cfca4cc36c1454fc6f56120bc76aab1456febcb5":"5b9TDz0t/n3okWuD4G/qVsrzW0rwg5Oj9/d4bsgyaSuc4B00f9MSKJ9VyWKIPOqTLQqzTv/tzD4S3bwhZQYl1A==","0332f47bda0f5a23e5575ca81701958b39eb8065c857e200c6e981c3c57f1c9112":"BA01GjnaAL3XXfb112a/aPXD3gWd0UUmKKyR1Pt\u002BhOGd13X2/2Ck1ybcjGxqrQiZZO\u002BvT571hclviOn9oS5XRQ=="}}},"network":199}
```

Get transaction hash as a response

```
Data relay success, the hash is shown as follows:
0x31782ba202f5730d786f6c15e912a4abf9cc92c7c31ab71a889ce6c938ccd5ac
```
 
