{{/*
Expand the name of the chart.
*/}}
{{- define "platform.name" -}}
{{- default .Chart.Name .Values.nameOverride | trunc 63 | trimSuffix "-" }}
{{- end }}

{{/*
Create chart name and version as used by the chart label.
*/}}
{{- define "platform.chart" -}}
{{- printf "%s-%s" .Chart.Name .Chart.Version | replace "+" "_" | trunc 63 | trimSuffix "-" }}
{{- end }}


{{/*
Create a default fully qualified app name.
We truncate at 63 chars because some Kubernetes name fields are limited to this (by the DNS naming spec).
If release name contains chart name it will be used as a full name.
*/}}
{{- define "platform.fullname" -}}
{{- if .Values.fullnameOverride }}
{{- .Values.fullnameOverride | trunc 63 | trimSuffix "-" }}
{{- else }}
{{- $name := default .Chart.Name .Values.nameOverride }}
{{- if contains $name .Release.Name }}
{{- .Release.Name | trunc 63 | trimSuffix "-" }}
{{- else }}
{{- printf "%s-%s" .Release.Name $name | trunc 63 | trimSuffix "-" }}
{{- end }}
{{- end }}
{{- end }}

{{/*
Common labels
*/}}
{{- define "platform.labels" -}}
helm.sh/chart: {{ include "platform.chart" . }}
{{ include "platform.selectorLabels" . }}
{{- if .Chart.AppVersion }}
version: {{ .Chart.AppVersion | quote }}
{{- end }}
managed-by: {{ .Release.Service }}
{{- end }}

{{/*
Selector labels
*/}}
{{- define "platform.selectorLabels" -}}
name: {{ include "platform.name" . }}
instance: {{ .Release.Name }}
{{- end }}


{{- define "platform.runSeedMigration" -}}
{{- if .Values.boostrapDatabase -}}
- name: run-seed
  imagePullPolicy: Always
  image: "{{ .Values.boostrapDatabase.image.repository }}:{{ .Values.boostrapDatabase.image.tag }}"
  command: ["make"]
  args: ["migrate", "ENV={{ .Values.environment }}", "AGENT={{ .Values.agentCode | lower }}", "DATABASE={{.RunSeedDatabase}}"]
  env:
    - name: MYSQL_HOST
      value: "{{ .Values.database.host }}"
    - name: MYSQL_PORT
      value: "{{ .Values.database.port }}"
    - name: MYSQL_DATABASE
      value: "{{ .Values.database.prefix }}{{.RunSeedDatabase}}"
    - name: DB_USER_NAME
      valueFrom:
        secretKeyRef:
          name: {{ include "platform.fullname" . }}-db-secrets
          key: mysql-username
    - name: DB_USER_PASSWORD
      valueFrom:
        secretKeyRef:
          name: {{ include "platform.fullname" . }}-db-secrets
          key: mysql-password
{{- end -}}
{{- end }}