import { Body, Controller, Get, HttpCode, Logger, Param, Post, Req } from '@nestjs/common';
import { ApiExcludeEndpoint, ApiOperation, ApiResponse, ApiTags } from '@nestjs/swagger';
import { WelcomeRewardRequest } from './dto/welcome.reward.request';
import { WelcomeRewardResult } from './dto/welcome.reward.result';
import { WelcomeService } from './welcome.service';
import { Request } from 'express';

@ApiTags('Welcome')
@Controller('/welcome')
export class WelcomeController {
    private readonly logger = new Logger(WelcomeController.name);
    constructor(private readonly welcomeService: WelcomeService) {
    }
    
    @Post('/reward')
    @HttpCode(200)
    @ApiOperation({ summary: 'Reward user for adding a social account.' })
    @ApiResponse({ status: 200, description: 'Reward transaction and amount info.', type: WelcomeRewardResult })
    @ApiResponse({ status: 500, description: 'Internal Server Error.' })
    async reward(
        @Req() req: Request,
        @Body() body: WelcomeRewardRequest
        ): Promise<WelcomeRewardResult> {
            this.logger.verbose(`${req.method} : ${req.url} : ${JSON.stringify(body)}`);

        return await this.welcomeService.reward(body);
    }
}
