import { Index, Column, Entity, PrimaryGeneratedColumn, Unique} from 'typeorm';

@Entity('dvita_reward') 
export class DvitaRewardEntity {
    @PrimaryGeneratedColumn()
    id: number;

    @Index()
    @Unique(['userId', 'socialNetwork', 'campaignId'])
    @Column()
    userId: string;

    @Column()
    userSocialHandle: string;

    @Column()
    address: string;

    @Column()
    dvitaAmount: string;

    @Column({ unique: true })
    dvitaTxHash: string;

    @Column()
    dvgAmount: string;

    @Column({ unique: true })
    dvgTxHash: string;
    
    @Column()
    accessToken: string;

    @Column()
    socialNetwork: string;

    @Column()
    campaignId: number;
}