import { Controller, Logger, OnApplicationBootstrap, OnApplicationShutdown } from "@nestjs/common";
import { BlockchainService } from "./blockchain.service";

@Controller('/blockchain')
export class BlockchainController implements OnApplicationBootstrap, OnApplicationShutdown {
    
    constructor(
        private readonly blockchainService: BlockchainService
    ) {
    }

    private readonly logger = new Logger(BlockchainController.name);

    onApplicationBootstrap(): any {
        try {
        this.blockchainService.connect();
        } catch(e) {
            this.logger.error(e);
        }
    }
    
    onApplicationShutdown(signal?: string): any {
        try {
        this.logger.debug(`Terminating with ${signal}...`);
        this.blockchainService.disconnect();
        } catch(e) {
            this.logger.error(e);
        }
    }
}