import { CanActivate, ExecutionContext, Injectable, Logger } from "@nestjs/common";
import { AuthGuard } from '@nestjs/passport';
import { Observable } from "rxjs";
import { AuthService } from "./auth.service";

@Injectable()
export class PubKeyAuthGuard implements CanActivate  {
    private readonly logger = new Logger(PubKeyAuthGuard.name);

    constructor(
        private readonly authService: AuthService
    ) {
        this.logger.debug(`Creating Guard...`);
    }
    
    canActivate(context: ExecutionContext): boolean | Promise<boolean> | Observable<boolean> {
        return new Promise(async (resolve, reject) => {
            try {
                const request = context.switchToHttp().getRequest();
                const token = request.headers?.authorization as string;
                const activate = await this.authService.validateToken(token);

                this.logger.debug(`Can authenticate with: ${token} -> ${activate}`);
    
                if (!activate) {
                    resolve(false);
                }
                resolve(true);
            } catch(e) {
                this.logger.error(e);
                reject(e);
            }
        });
    }
}