import { Module } from "@nestjs/common";
import { AuthService } from "./auth.service";
import { PubKeyAuthGuard } from "./pubkey.auth.guard";
import { PassportModule } from '@nestjs/passport';

@Module({
    imports: [
        PassportModule.register({ defaultStrategy: 'public-key' })
    ],
    providers: [
        AuthService,
        PubKeyAuthGuard
    ],
    exports: [
        AuthService,
        PubKeyAuthGuard
    ]
})
export class AuthModule {
}
