#!/usr/bin/env bash

#
# Error handling definitions.
#
set -euf -o pipefail

#
# Select node type:
#   public (wallet node)
#   utility (public with RPC enabled)
#   partner (like core but on-premises 3rd-party)
#   core (master consensus node)
#   seed (announcer node)
#

NODE_TYPE="${NODE_TYPE:=public}"

NODE_TYPES="public utility partner core seed"

if [[ ! " $NODE_TYPES " =~ .*\ $NODE_TYPE\ .* ]]; then
    echo "Wrong '$NODE_TYPE' node type." >&2
    exit 1
fi

echo "Using '$NODE_TYPE' node..."

#
# Setup current config if not provided by the docker mounts.
#
DVITA_PLUGINS_DIR=./Plugins

if [[ ! $NODE_TYPE =~ ^(core)$ ]]; then  

    rm -f ./config.json
    ln -s ${NODE_TYPE}/config.json ./config.json

    rm -f ${DVITA_PLUGINS_DIR}/ApplicationLogs/config.json
    rm -f ${DVITA_PLUGINS_DIR}/DBFTPlugin/config.json
    rm -f ${DVITA_PLUGINS_DIR}/OracleService/config.json
    rm -f ${DVITA_PLUGINS_DIR}/TokensTracker/config.json
    rm -f ${DVITA_PLUGINS_DIR}/RpcServer/config.json
    rm -f ${DVITA_PLUGINS_DIR}/StatesDumper/config.json
    rm -f ${DVITA_PLUGINS_DIR}/StateService/config.json
    rm -f ${DVITA_PLUGINS_DIR}/DvitaBlockListener/config.json
    rm -f ${DVITA_PLUGINS_DIR}/DvitaExtendedRpc/config.json

    mkdir -p ${DVITA_PLUGINS_DIR}/ApplicationLogs
    mkdir -p ${DVITA_PLUGINS_DIR}/DBFTPlugin
    mkdir -p ${DVITA_PLUGINS_DIR}/OracleService
    mkdir -p ${DVITA_PLUGINS_DIR}/TokensTracker
    mkdir -p ${DVITA_PLUGINS_DIR}/RpcServer
    mkdir -p ${DVITA_PLUGINS_DIR}/StatesDumper
    mkdir -p ${DVITA_PLUGINS_DIR}/StateService
    mkdir -p ${DVITA_PLUGINS_DIR}/DvitaBlockListener
    mkdir -p ${DVITA_PLUGINS_DIR}/DvitaExtendedRpc

    ln -s /$DVITA_NODE_DIR/${NODE_TYPE}/plugins/ApplicationLogs/config.json    ${DVITA_PLUGINS_DIR}/ApplicationLogs/
    ln -s /$DVITA_NODE_DIR/${NODE_TYPE}/plugins/DBFTPlugin/config.json         ${DVITA_PLUGINS_DIR}/DBFTPlugin/
    ln -s /$DVITA_NODE_DIR/${NODE_TYPE}/plugins/OracleService/config.json      ${DVITA_PLUGINS_DIR}/OracleService/
    ln -s /$DVITA_NODE_DIR/${NODE_TYPE}/plugins/TokensTracker/config.json      ${DVITA_PLUGINS_DIR}/TokensTracker/
    ln -s /$DVITA_NODE_DIR/${NODE_TYPE}/plugins/RpcServer/config.json          ${DVITA_PLUGINS_DIR}/RpcServer/
    ln -s /$DVITA_NODE_DIR/${NODE_TYPE}/plugins/StatesDumper/config.json       ${DVITA_PLUGINS_DIR}/StatesDumper/
    ln -s /$DVITA_NODE_DIR/${NODE_TYPE}/plugins/StateService/config.json       ${DVITA_PLUGINS_DIR}/StateService/
    ln -s /$DVITA_NODE_DIR/${NODE_TYPE}/plugins/DvitaBlockListener/config.json ${DVITA_PLUGINS_DIR}/DvitaBlockListener/
    ln -s /$DVITA_NODE_DIR/${NODE_TYPE}/plugins/DvitaExtendedRpc/config.json   ${DVITA_PLUGINS_DIR}/DvitaExtendedRpc/
fi

#
# Start node screen session.
#
screen -DmS node dotnet neo-cli.dll --rpc --log
