import { Body, Controller, Get, Logger, Post, Req } from '@nestjs/common';
import { ApiOperation, ApiResponse, ApiTags } from '@nestjs/swagger';
import { Request } from 'express';
import { CreateTalismanBidDto } from './dto/create.talisman.bid.dto';
import { TalismanBidDto } from './dto/talisman.bid.dto';
import { TalismanBidResultDto } from './dto/talisman.bid.result.dto';
import { TalismanService } from './talisman.service';

@ApiTags('Talisman')
@Controller('/talisman')
export class TalismanController {
    private readonly logger = new Logger(TalismanController.name);

    constructor(
        private readonly talismanService: TalismanService
    ) {
    }

    @Get('/bid/highest')
    @ApiOperation({ summary: 'Get highest Talisman bid' })
    @ApiResponse({ status: 200, description: 'The highest Talisman bid', type: TalismanBidDto })
    @ApiResponse({ status: 500, description: 'Internal Server Error' })
    async getHighestBid(
        @Req() req: Request
    ): Promise<TalismanBidDto> {
        this.logger.verbose(`${req.method} : ${req.url}`);
        return this.talismanService.getHighestBid();
    }

    @Get('/bids')
    @ApiOperation({ summary: 'Get all Talisman bids' })
    @ApiResponse({ status: 200, description: 'The all Talisman bids', type: TalismanBidDto, isArray: true })
    @ApiResponse({ status: 500, description: 'Internal Server Error' })
    async getAllBids(
        @Req() req: Request
    ): Promise<TalismanBidDto[]> {
        this.logger.verbose(`${req.method} : ${req.url}`);
        return this.talismanService.getAllBids();
    }

    @Post('/bid')
    @ApiOperation({ summary: 'Create new Talisman bid' })
    @ApiResponse({ status: 201, description: 'The new Talisman bid', type: TalismanBidResultDto })
    @ApiResponse({ status: 400, description: 'Bad Request' })
    @ApiResponse({ status: 500, description: 'Internal Server Error' })
    async createTalismanBid(
        @Req() req: Request,
        @Body() body: CreateTalismanBidDto
    ): Promise<TalismanBidResultDto> {
        this.logger.verbose(`${req.method} : ${req.url}`);
        return this.talismanService.createTalismanBid(body);
    }
}
