import { ApiProperty, ApiPropertyOptional } from "@nestjs/swagger";
import { Transform } from "class-transformer";
import { IsNotEmpty, IsNumber, IsString, MaxLength, MinLength } from "class-validator";
import { TalismanBidEntity } from "../../entity/talisman.bid.entity";

export class TalismanBidDto {
    @ApiProperty()
    @IsString()
    @IsNotEmpty()
    @MinLength(2)
    @MaxLength(16)
    currencyCode: string;

    @ApiProperty()
    @IsNumber({ allowInfinity: false, allowNaN: false })
    @Transform(params => parseFloat(params.value))
    price: number;

    @ApiPropertyOptional()
    lotId?: number;

    constructor(
        currencyCode: string,
        price: number,
        lotId?: number
    ) {
        this.currencyCode = currencyCode;
        this.price = price;
        this.lotId = lotId;
    }

    public static fromEntity(entity: TalismanBidEntity): TalismanBidDto {
        return new TalismanBidDto(
            entity.currencyCode,
            entity.price,
            entity.lotId
        );
    }
}
