import { ApiProperty, ApiPropertyOptional } from "@nestjs/swagger";
import { IsEmail, IsNotEmpty, IsNumber, IsString, MaxLength, MinLength } from "class-validator";

export class CreateTalismanBidDto {
    @ApiProperty()
    @IsEmail()
    @IsNotEmpty()
    @MinLength(4)
    @MaxLength(255)
    email: string;

    @ApiProperty()
    @IsString()
    @IsNotEmpty()
    @MinLength(2)
    @MaxLength(16)
    currencyCode: string;

    @ApiProperty()
    @IsNumber({ allowInfinity: false, allowNaN: false })
    price: number;

    @ApiPropertyOptional()
    lotId?: number;
}
