import { Column, CreateDateColumn, Entity, Generated, Index, PrimaryGeneratedColumn, UpdateDateColumn } from 'typeorm';

@Entity('talisman_bid')
export class TalismanBidEntity {
    @PrimaryGeneratedColumn()
    id: number;

    @Index()
    @Generated('uuid')
    @Column({ unique: true, nullable: false })
    uuid: string;

    @Index()
    @Column({ unique: false, nullable: false })
    email: string;

    @Index()
    @Column({ unique: false, nullable: false, default: 'USD' })
    currencyCode: string;

    @Column('decimal', { precision: 8, scale: 2, unique: false, nullable: false })
    price: number;

    @Column({ unique: false, nullable: true })
    lotId: number;

    @CreateDateColumn()
    createdDate: Date;

    @UpdateDateColumn()
    modifiedDate: Date;
}