import { utils } from 'ethers';

export function verifySignatureEth(message: string, signature: string): string {
    const signerAddress = utils.verifyMessage(utils.arrayify(utils.hexlify(utils.toUtf8Bytes(message))), signature);
    if (!signerAddress) {
        throw new Error('Invalid signature');
    }
    return signerAddress.toLowerCase();
}
