import { Component, OnDestroy, OnInit } from '@angular/core';
import { Subscription } from 'rxjs';
import { NotificationData, NotificationService } from '../../services/notification.service';

@Component({
    selector: 'app-notification',
    templateUrl: './notification.component.html',
    styleUrls: ['./notification.component.scss'],
})
export class NotificationComponent implements OnInit, OnDestroy {
    notificationData!: NotificationData | null;
    subscription!: Subscription;
    timeout: any = setTimeout(() => { })

    constructor(
        private notificationService: NotificationService,
    ) { }

    ngOnInit(): void {
        this.subscription = this.notificationService.notification.subscribe(res => {
            clearTimeout(this.timeout);
            this.notificationData = res;
            this.timeout = setTimeout(() => {
                this.notificationService.notification.next(null);
            }, 5000);
        });
    }

    ngOnDestroy(): void {
        this.subscription.unsubscribe();
    }
    close() {
        this.notificationService.notification.next(null);
    }
}